<?php

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\BannerModel;
use think\Controller;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/14
 * Time : 15:12
 * Intro:
 */
class Banner extends Basic
{
    protected $bannerModel;

    public function __construct()
    {
        $this->bannerModel = new BannerModel();
    }


    /**
     * 查询banner列表
     * @return \think\Response
     */
    public function index()
    {
        return view("banner/banner");
    }

    public function getBannerList()
    {
        $field = "id,title,pic_path,url,sort,hits,is_show,up_user,create_time,update_time";
        $params['is_show'] = array( "eq", 0 );
        $pageNo = empty($_POST['pageNo']) ? 1 : $_POST['pageNo'];
        $pageSize = empty($_POST['pageSize']) ? 15 : $_POST['pageSize'];
        $result["list"] = $this->bannerModel
            ->getBannerList($pageNo, $pageSize, "sort desc", $field, $params);
        $result["total"] = $this->bannerModel
            ->getBannerTotal($params);
        return $this->response("200", "request success", $result);
    }


    /**
     * 新增or修改数据
     * @return \think\Response
     */
    public function addOrSave()
    {
        /*  $params = array(
              "id" => 2,
              "is_show" => 0
          );*/
        if (isset($_POST["id"])) {
            $params["id"] = $_POST["id"];
        }
        if (isset($_POST["title"])) {
            $params["title"] = $_POST["title"];
        }
        if (isset($_POST["url"])) {
            $params["url"] = $_POST["url"];
        }
        if (isset($_POST["cover_image"])) {
            $params["cover_image"] = $_POST["cover_image"];
        }
        if (isset($_POST["sort"])) {
            $params["sort"] = $_POST["sort"];
        }
        if (isset($_POST["is_show"])) {
            $params["is_show"] = $_POST["is_show"];
        }

        if (empty($params["title"]) || empty($params["url"]) || empty($params["cover_image"]) || empty($params["sort"])) {
            return $this->response("101", "请提交正确的请求参数");
        }
        if (isset($params['id'])) {
            $msg = "修改";
        } else {
            $msg = "新增";
            $params["is_show"] = 0;
        }
        $result = $this->bannerModel->addOrUpdate($params);
        if ($result['code'] == 200) {
            return $this->response("200", $msg . "成功", $result["msg"]);
        } else {
            return $this->response("101", $msg . $result["msg"]);
        }
    }


    /**
     * 修改是否显示
     * @return \think\Response
     */
    public function upIsShow()
    {
         $params = array(
             "id" => $_POST["id"],
             "is_show" => $_POST["is_show"]
         );
         $result = $this->bannerModel->upIsShow($params);
         if ($result['code'] == 200) {
             return $this->response("200", "update success", $result["msg"]);
         } else {
             return $this->response("101", "update error");
         }
    }
}