<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/17
 * Time: 13:46
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\AAgents;
use app\model\GHouses;
use think\Request;


class Houses extends Basic
{
    protected $house;
    protected $code = 200;
    protected $data = '';
    protected $msg  = '';

    public function __construct(Request $request = null)
    {

        parent::__construct($request);
        $this->house = new GHouses();
    }

    public function index() {
        return view('houseList');
    }

    /**
     * 新增和编辑商铺
     *
     * @return \think\response\View
     * @throws \Exception
     * @throws \think\exception\PDOException
     */
    public function edit() {
        $result['code'] = 200;
        $result['msg'] = '';

        if ($this->request->isPost()) {
            $this->house->startTrans();
            $house_id = $this->house->add($this->params); //添加或编辑商铺
            if ($house_id) {
                $this->house->commit();
                $return = $this->response($result['code'], $result['msg'],['id',$house_id]);
            } else {
                $this->house->rollback();
                $return = $this->response(101, 'add houses is error');
            }
        } elseif ($this->params['id']){
            if ($this->request->isAjax()) {
                //获取商铺详情
                $house = new GHouses();
                $result['data'] = $house->getHouseById($this->params['id']);
                $return = $this->response($result['code'], $result['msg'], $result['data']);
            } else {
                //商铺添加页面
                $return = view('edit');
            }
        } else {
            //商铺添加页面
            $return = view('edit');
        }
        return $return;
    }

    /**
     * 楼盘列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
        $pageSize = empty($this->params['pageSize']) ? 15 : $this->params['pageSize'];

        $fields = '';

        /*精选商铺--0是1否*/
        if ($this->params['is_carefully_chosen'] != NULL) {
            $where['is_carefully_chosen'] = $this->params['is_carefully_chosen'];
        }

        /*0是1否显示在c端用户*/
        if ($this->params['is_show'] != NULL) {
            $where['is_show'] = $this->params['is_show'];
        }

        /*商铺类型（0商场，1街铺）*/
        if ($this->params['shop_type'] != NULL) {
            $where['shop_type'] = $this->params['shop_type'];
        }

        /*所在城市*/
        if ($this->params['city'] != NULL) {
            $where['city'] = $this->params['city'];
        }

        /*所在区*/
        if ($this->params['disc'] != NULL) {
            $where['disc'] = $this->params['disc'];
        }

        /*状态 0待审批  1上架 2下架 3回收*/
        if ($this->params['status'] != NULL) {
            $where['status'] = $this->params['status'];
        }

        /*价格 -1表示营业额扣点 存分*/
        if ($this->params['rent_price'] != NULL) {
            switch ($this->params['rent_price']) {
                case 1:
                    $where['rent_price'] = ['>',10000];break;
                case 2:
                    $where['rent_price'] = ['between','10000,30000'];break;
                default :
                    $where['rent_price'] = ['>', '30000'];
            }
        }

        /*对内楼盘名*/
        if ($this->params['internal_title'] != NULL) {
            $where['internal_title'] = ['LIKE', $this->params['internal_title'].'%'];
        }

        /*是否独家0否1是*/
        if ($this->params['is_exclusive_type'] != NULL) {
            $where['is_exclusive_type'] = ['LIKE', $this->params['is_exclusive_type'].'%'];
        }

        /*开始时间*/
        if ($this->params['start_date'] != NULL) {
            $where['create_time'] = ['> time', $this->params['start_date']. ' 00:00:00'];
        }

        /*结束时间*/
        if ($this->params['end_date'] != NULL) {
            $where['create_time'] = ['< time',$this->params['end_date']. ' 23:59:59'];
        }

        /*开始结束时间*/
        if ($this->params['start_date'] != NULL && $this->params['end_date'] != NULL) {
            $where['create_time'] = ['between time',[$this->params['start_date'].' 00:00:00'],$this->params['end_date']. ' 23:59:59'];
        }

        /*根据库存判断是否已租*/
        if ($this->params['leased'] != NULL) {
            if ($this->params['leased'] == 0) {
                $where['residue_num'] = 0;
            } else {
                $where['residue_num'] = ['<>',0];
            }
        }

        /*业态*/
        if ($this->params['industry_type'] != NULL) {
            $where['industry_type'] = ['LIKE',$this->params['industry_type'].'%'];
        }

        //案场权限人搜索
        if (empty($params['dish'])) {
            /*楼盘编号*/
            if ($params['id'] != NULL) {
                $where['id'] = $params['id'];
            }
            $where['status'] = ['<>',3];
            $data['data']['list'] = $this->house->getHouseList($pageNo, $pageSize, 'id DESC', $fields, $where);
            $data['data']['total'] = $this->house->getTotal($where);
        } else {
            //盘方人搜索
            /*楼盘编号*/
            if ($params['id'] != NULL) {
                $where['a.id'] = $params['id'];
            }
            $where['a.status'] = ['<>',3];
            $where['c.name'] = ['LIKE',$params['dish'].'%'];
            $where['b.type'] = ['=',1];
            $data['data']['list'] = $this->house->getHouseListDish($pageNo, $pageSize, 'a.id DESC', $fields, $where);
            $data['data']['total'] = $this->house->getHouseListDishTotal($where);
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 伪删除商铺
     *
     * @return \think\Response
     */
    public function del() {
        $data['status'] = 200;
        $data['msg']    = '';
        $data['data']   = '';

        if ($this->params['id']) {
            $this->house->isUpdate(true)->save(['status'=>3],['id'=>$this->params['id']]);
            $data['msg'] = 'successfully deleted';
        } else {
            $data['status'] = 101;
            $data['msg']    = 'id is null';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 是否精选商铺
     *
     * @return \think\Response
     */
    public function carefullyChosen() {
        if ($this->params['houses_id'] != NULL && $this->params['is_carefully_chosen'] != NULL) {
            $data['is_carefully_chosen'] = $this->params['is_carefully_chosen'];
            $this->data = $this->house->editData($data,$this->params['houses_id'],'id');
        } else {
            $this->code = 101;
            $this->msg  = 'houses_id or is_carefully_chosen is null';
        }

        return $this->response($this->code, $this->msg, $this->data);
    }

    /**
     * 商铺列表添加和编辑独家
     *
     * @return \think\Response
     * @throws \Exception
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function editExclusive() {
        if ($this->params['houses_id']) {
            $this->data = $this->house->exclusive($this->params,$this->params['houses_id']);
        } else {
            $this->code = 101;
            $this->msg  = 'houses_id is null';
        }

        return $this->response($this->code, $this->msg, $this->data);
    }

    /**
     * 获取独家方
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getExclusive() {
        if ($this->params['houses_id']) {
            $this->data = $this->house->getExclusive($this->params['houses_id']);
        } else {
            $this->code = 101;
            $this->msg  = 'houses_id is null';
        }

        return $this->response($this->code, $this->msg, $this->data);
    }

    /**
     * 操作记录
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getRecords()
    {
        if ($this->params['houses_id']) {
            $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
            $pageSize = empty($this->params['pageSize']) ? 15 : $this->params['pageSize'];
            $field = 'id,name,remark,create_time';
            $params['houses_id'] = $this->params['houses_id'];
            $params['type']      = 2;
            $agents = new AAgents();
            $this->data = $agents->getRecords($pageNo, $pageSize,'id DESC', $field, $params);
        } else {
            $this->code = 101;
            $this->msg  = 'houses_id is null';
        }

        return $this->response($this->code, $this->msg, $this->data);
    }
}