<?php

namespace app\api\controller;

use app\api\extend\Basic;
use app\model\AppVersion;
use think\Request;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/26
 * Time : 13:57
 * Intro:
 */
class Version extends Basic
{
    protected $appVersion;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->appVersion = new AppVersion();
    }

    public function index()
    {
        return view("version/index");
    }

    /**
     * 获取最近版本号
     * @return \think\Response
     */
    public function getVersionNo()
    {
        $type = $this->params["type"];
        if(isset($type)){
            $this->response("101","请求的设备类型不能为空");
        }
        $versionResult = $this->appVersion->getVersion($type);
        return $this->response("200", "request success", $versionResult);
    }
}