<?php

namespace app\model;

use think\Model;

class GHousesToAgents extends BaseModel
{
    protected $table = 'g_houses_to_agents';
    protected $date  = '';

    public function __construct()
    {
        $this->date = date('Y-m-d H:i:s');
    }

    /**
     * @param $agents_id
     * @param $houses_id
     * @param $type 案场权限人:0,盘方:1,独家:2
     * @return array|false
     * @throws \Exception
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function addAgents($agents_id, $houses_id, $type){
        $agent_arr   = array();
        $date        = date('Y-m-d H:i:s');
        $agents_id   = array_unique(explode(',',$agents_id));

        $where['type']      = $type;
        $where['houses_id'] = $houses_id;
        $where['is_del']    = 0;

        $records = new GOperatingRecords();
        $agents = new AAgents();
        //为空全部伪删除
        if (empty($agents_id[0])) {
            if ($type == 2) {
                $house_agents = $this->field('agents_id')->where('houses_id',$houses_id)->where('is_del',0)->select();
                $name = array();
                foreach ($house_agents as $k2 => $v2){
                    $name[] = $agents->where('id',$v2['agents_id'])->value('name');
                }
                $records->record('',2,'删除盘方'.implode(',',$name),$houses_id);
            }
            $res = $this->where($where)->setField('is_del',1);
        } else {
            $houses_data = $this->where($where)->select();
            $key = 0;
            foreach ($houses_data as $k=>$v) {
                if (!in_array($v['agents_id'], $agents_id) && ($type == $v['type']) && ($v['agents_id'] != NULL)) {
                    $agent_arr[$key]['id'] = $v['id'];
                    $agent_arr[$key]['is_del'] = 1;
                    $agent_arr[$key]['update_time'] = $date;
                    $key++;

                    if ($type == 2) {
                        $del_agents_id[] = $v['agents_id'];
                    }
                }
            }

            foreach ($agents_id as $k=>$v) {
                $check = $this->where([
                    'houses_id' => $houses_id,
                    'agents_id' => $v,
                    'is_del'    => 0 ,
                    'type'      => $type
                ])->find();
                if ($check) {
                    continue;
                }
                $agent_arr[$key]['agents_id'] = $v;
                $agent_arr[$key]['houses_id'] = $houses_id;
                $agent_arr[$key]['type'] = $type;
                $agent_arr[$key]['create_time'] = $this->date;
                $agent_arr[$key]['update_time'] = $this->date;
                $key++;

                if ($type == 2) {
                    $record_agents_id[] = $v;
                }
            }


            if (count($del_agents_id) > 0) {
                $name = array();
                foreach ($del_agents_id as $k2 => $v2){
                    $name[] = $agents->where('id',$v2)->value('name');
                }
                $records->record('',2,'删除盘方:'.implode(',',$name),$houses_id);
            }

            if (count($record_agents_id) > 0) {
                $records = new GOperatingRecords();
                $name = array();
                foreach ($record_agents_id as $k2 => $v2){
                    $name[] = $agents->where('id',$v2)->value('name');
                }
                $records->record('',2,'新增盘方:'.implode(',',$name),$houses_id);
            }

            $res = $this->saveAll($agent_arr);
        }

        return $res;
    }

    /**
     * 解除经纪人和楼盘关系
     *
     * @param $id
     * @return bool|false|int
     */
    public function del($id, $houses_id) {
        if ($id) {
            $res = $this->save(['is_del' => 1],['agents_id'=>$id,'houses_id'=>$houses_id]);
        } else {
            $res = false;
        }

        return $res;
    }

    /**
     * 经纪人与楼盘信息列表分页
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param string $field
     * @param string $params
     * @return false|\PDOStatement|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getAgentsHousesList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        return $this->field($field)
            ->alias('a')
            ->join('a_agents b', 'a.agents_id = b.id','left')
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

    /**
     * 楼盘对应的经纪人信息
     *
     * @param $houses_id
     * @return false|\PDOStatement|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHousesAgents($houses_id) {
        $select_data = $this->field('b.id,name,a.type,b.phone')->alias('a')
            ->join('a_agents b','a.agents_id = b.id','LEFT')
            ->where([
                'houses_id' => $houses_id,
                'is_del'    => 0
            ])->select();

        return $select_data;
    }
}
