<?php
/**
 * Created by PhpStorm.
 * User: hujun
 * Date: 2018/1/17
 * Time: 13:26
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\GBusinessDistrict;
use app\model\Regions;

class BusinessDistrict extends Basic
{
    public function index() {
        return view('business_district/index');
    }

    public function edit() {

        if ($this->request->isPost()) {
            $result['code'] = 200;
            $result['msg'] = '';
            $params = $this->request->param();
            $business = new GBusinessDistrict();

            if ($params['type'] == NULL) {
                $data['province'] = $params['province'];
                $data['city'] = $params['city'];
                $data['disc'] = $params['disc'];

                $data['province_code'] = $params['province_code'];
                $data['city_code'] = $params['city_code'];
                $data['disc_code'] = $params['disc_code'];
                $data['name']      = $params['business'];
                $data['create_time'] = date('Y-m-d H:i:s');
            } else {
                $data['status'] = $params['type'];
            }

            if ($params['id']) {
                $num = $business->save($data, ['id' => $params['id']]);
            } else {
                $business->save($data);
                $num = $business->id;
            }

            if ($num) {
                $result['code'] = 200;
                $result['msg']    = '添加成功';
            } else {
                $result['code'] = 101;
                $result['msg']    = '添加失败';
            }
            return $this->response( $result['code'], $result['msg'], $result['data']);
        } elseif ($this->request->param('id')) {
            $business = new GBusinessDistrict();
            $result['data'] = $business->get($this->request->param('id'));
            return $this->response( 200, '', $result['data']);
        } else{
            return view('business_district/edit');
        }
    }

    /**
     * 删除商圈
     *
     * @return \think\Response
     */
    public function del() {
        $result['code'] = 200;
        $result['msg'] = '';
        $id = $this->request->param('id');
        $business = new GBusinessDistrict();
        $num = $business->save(['is_del' => 1],['id'=>$id]);

        if ($num != 1) {
            $result['code'] = 101;
        }
        return $this->response( $result['code'], '');
    }

    /**
     * 获取商圈列表
     *
     * @return mixed
     */
    public function getBusiness() {
        $data['status'] = 200;
        $data['msg'] = '';

        $params = $this->request->param();
        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];
        $auth_group = New GBusinessDistrict();
        $where = 'is_del = 0';

        if ($params['name'] != NULL) {
            $where .= ' and name like "'.$params['name'].'%"';
        }
        $fields = 'id,name,province,city,disc,status,create_time';
        $data['list'] = $auth_group->getList($pageNo, $pageSize, 'id desc',$fields, $where);
        $data['total'] = $auth_group->getTotal($where);
        return $this->response(200, '', $data);
    }

    /**
     * 获取省市区数据
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function regions() {
        $params = $this->request->param();
        $regions = new Regions();
        $data = $regions->getRegions($params['code'], $params['parent_code'], $params['type']);
        return $this->response(200, '', $data);
    }
}