<?php

namespace app\api\controller;
use app\api\extend\Basic;
use app\model\Agents;
use app\model\Evaluate;
use app\model\EvaluateSign;
use app\model\JournalAccounts;
use think\Db;
/**
 * Description of Agents
 *
 * @user :hujun
 * @date :2017-12-11
 * @time :11:15:05
 * Intro :
 */
class Broker extends Basic{
    
    /**
     * 获取当前商铺或街铺的经纪人
     * 
     * @return type
     */
    public function index() {
        $params = $this->params;
        $data['status'] = 101;      
        $data['data']   = array();
        if ($params['house_id']) {
            
            $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
            $pageSize = empty($params['pageSize']) ? PAGESIZE : $params['pageSize'];
            
            $agents = new Agents();
            $data['msg']  = '';
            $fields = 'a.id,realname,phone,COUNT(b.id) evaluate,sum(evaluate_grade) as evaluate_grade,a.head_portrait';
            $list = $agents->getUser($pageNo, $pageSize, 'evaluate desc', $fields, '', $params['house_id']);

            if ($list) {
                foreach ($list as $k=>$v) {
                    $v->head_portrait = ADMIN_URL_TL.'user_header/'.$v->head_portrait;
                    $list[$k] = $v->toArray();

                    if ($list[$k]['evaluate_grade']) {
                        $evaluate_grade = floor(($list[$k]['evaluate_grade']/2)/$list[$k]['evaluate']);
                        $evaluate_grade = $evaluate_grade;
                    } else {
                        $evaluate_grade = 0;
                    }

                    $list[$k]['evaluate_grade'] = $evaluate_grade;
                }
            }

            $data['data']['list'] = $list;
            $data['data']['pageNo']   = $pageNo;
            $data['data']['pageSize'] = $pageSize;
            $data['status'] = 200;
        } else {
            $data['msg']  = 'house_id 为空';            
        }
        return $this->response($data['status'], $data['msg'], $data['data'] );
    }
    
    /**
     * 评价经纪人
     * 
     * @return type
     */
    public function appraiser() {
        $params = $this->params;
        $data['status'] = 101;
        $data['data']   = array();
        $data['msg']    = '';

        if (empty($params['agents_id'])) {
            return $this->response($data['status'], 'agents_id is null');
        }

        if (empty($params['house_id'])) {
            return $this->response($data['status'], 'house_id is null');
        }
        if (empty($this->userId)) {
            return $this->response($data['status'], 'user_id is null');
        }

        if (empty($params['source'])) {
            return $this->response($data['status'], 'source is null');
        }

        $date = date('Y-m-d H:i:s');
        $id_arr = array();
        if (isset($params['sign_name'])) {
            $evaluate_sign = new EvaluateSign();
            foreach ($params['sign_name'] as $v) {
                $sign_data[] = [
                    'sign_name' => $v,
                    'point_obj' => 0,
                    'is_del' => 0,
                    'create_time' => $date,
                    'update_time' => $date,
                ];
            }
            $resutl = $evaluate_sign->saveAll($sign_data);
            foreach ($resutl as $vv) {
                $id_arr[] = $vv->id;
            }
        }

        $evaluate = new Evaluate();
        $evaluate->save([
            'user_id'   => $this->userId,
            'agents_id' => $params['agents_id'],
            'source'    => $params['source'],
            'record_id' => $params['record_id'],
            'evaluate_grade'   => $params['evaluate_grade'],
            'evaluate_content' => $params['evaluate_content'],
            'evaluate_sign'    => implode(',', $id_arr),
            'create_time'  => $date,
            'update_time' => $date,
            'is_show'  => 0,
            'house_id' => $params['house_id']
        ]);

        if ($evaluate->id) {
            $data['data']   = ['id'=> $evaluate->id];
            $data['status'] = 200;
            $data['msg']    = '评价成功';
        } else {
            $data['msg'] = '评价失败';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }
    
    
    /**
     * 查询评论和成交记录
     * 
     * @return type
     */
    public function  commentAndDeal() {
        $params = $this->params;
        $data['status'] = 200;
        $data['data']   = array();
        $data['msg']    = '';

        if ($params['agent_id']) {
            $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
            $pageSize = empty($params['pageSize']) ? PAGESIZE : $params['pageSize'];
            
            $evalutate = new Evaluate();
            $journal  = new JournalAccounts();
            
            $fields_evaluate = 'house_id,user_id,user_nick,user_phone,user_pic,evaluate_grade,evaluate_content,evaluate_sign,a.create_time,record_id,a.source';
            $fields_journal  = 'a.house_id,j.singntime';
            switch ($params['type']) {
                case 0:
                    //评价列表信息
                    $result['evaluate'] = $evalutate->getEvaluate($pageNo, $pageSize, 'a.id desc', $fields_evaluate, '', $params['agent_id']);
                    //成交记录
                    $result['journalAccounts'] = $journal->getJournalHouseInfo($pageNo, $pageSize, 'j.id desc', $fields_journal, 'j.transaction_status = 3', $params['agent_id']);
                    $data['data'] = $result;
                    break;
                case 1:
                    //评价列表信息
                    $result['evaluate'] = $evalutate->getEvaluate($pageNo, $pageSize, 'a.id desc', $fields_evaluate, '', $params['agent_id']);
                    $data['data'] = $result;
                    break;
                case 2:
                    //成交记录
                    $result['journalAccounts'] = $journal->getJournalHouseInfo($pageNo, $pageSize, 'j.id desc', $fields_journal, 'j.transaction_status = 3', $params['agent_id']);
                    $data['data']   = $result;
                    break;
                default:
                    $data['stauts'] = 101;
                    $data['msg']    = 'type is null';
                    break;
            }
        } else {
            $data['msg'] = 'agent_id is null';
        }
        
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
    
    /**
     * 经纪人详情
     * 
     * @return type
     */
    public function brokerDetail() {

        $data['status'] = 200;
        $data['data']   = array();
        $data['msg']    = '';

        if ($this->params['agent_id']) {
            $agents = new Agents();
            $data['data'] = $agents->agentsDetail($this->params['agent_id']);
        } else {
            $data['status'] = 101;
            $data['msg']    = 'agent_id is null';
        }
        
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
}
