$(function() {
	$(document.body).show();
	var _doc = $(document);
	var _agentId = getUrlParam('agentId');
	var _token = localStorage.getItem('token');
	
	var loadItem = $('#loading_pic');
	var noMoreItem = $('#no_more');
	var zanWuItem = $('#zanwu_data');
	var pageInit = 1; //要从第一页开始
	var stopstatus = true;
	var _zanwuFlag = true; //暂无是否应该出现
	var _loadOverFlag = false; //一个搜索（包含分页）是否结束
	
	ajaxUl(scroll);

	function dealScale(obj) {
		if(obj['shangpu_type'] == '0') {
			return Number(obj['room_area']) + '-' + Number(obj['room_area2']) + 'm²';
		} else {
			return Number(obj['room_area']) + 'm²';
		};
	};

	function dealTags(arr) {
		if(arr.length > 0 && arr[0] != '') {
			if(arr.length < 3) {
				var _htmlTemp = '';
				for(var i = 0; i < arr.length; i++) {
					_htmlTemp += '<span>' + arr[i] + '</span>';
				};
				return _htmlTemp;
			} else {
				return '<span>' + arr[0] + '</span><span>' + arr[1] + '</span><span>' + arr[2] + '</span>';
			};
		} else {
			return '';
		}
	};

	function ajaxUl(fn){
		$.ajax({
			type: 'get',
			url: ServerHost + '/api/commentAndDeal',
			timeout: 30000,
			dataType: 'json',
			data: {
				'agent_id': _agentId,
				'type': 2,
				'pageNo': pageInit,
				'pageSize': 10,
				'AuthToken': _token
			},
			beforeSend: function() {
				loadItem.show();
				noMoreItem.hide();
				zanWuItem.hide();
			},
			success: function(data) {
				if(typeof data === 'object') {
					if(data['code'] == 200) {
						//成交列表
						if(data['data']['journalAccounts'] && data['data']['journalAccounts'].length > 0) {
							_zanwuFlag = false;
							stopstatus = true;
							pageInit++; //页数+1
							var _html = "";
							$.each(data['data']['journalAccounts'], function(i, item) {
								_html += '<li class="oh"><div class="fl oh"><img src="{5}" onerror="javascript:this.src=\'{6}\'"></div><div class="fl"><h3 class="shangpu-name ellipsis">{0}</h3><p class="qianyue-time">签约时间：{1}</p><p class="mianji-scale">{2}</p><p class="zuji-price">租金均价：<span>{3}</span>元/月</p><p class="sp-text ellipsis oh">{4}</p></div></li>'.stringFormatObj({
									'0': item['title'],
									'1': item['singntime'],
									'2': dealScale(item),
									'3': item['price'],
									'4': dealTags(item['shangpu_tags']),
									'5': location.protocol+'//'+item['img'],
									'6': ServerHost + '/resource/image/pzz_.jpg'
								});
							});
							$('.chengjiao-list-area>ul').append(_html);
							if(data['data']['journalAccounts'].length < 10) {
								stopstatus = false;
								_loadOverFlag = true;
							};
							fn && fn();
						} else {
							$('.chengjiao-list-area .zanwu_data').show();
						};
					} else {
						layerTipsX(data['msg']);
					};
				} else {
					layerTipsX('数据错误');
				};
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				layerTipsX('error');
			},
			complete: function(xhr, textStatus) {
				(textStatus === 'timeout') && layerTipsX('请求超时');
				loadItem.hide();
				if(_zanwuFlag) {
					zanWuItem.show();
				} else {
					_loadOverFlag && noMoreItem.show();
				};
			}
		});
	};
	
	//滚动加载更多，目前没有启用
	function scroll(){
		$(window).scroll(function(){
			var _this = $(this);
			if(Math.max($(document).height() - _this.scrollTop() - _this.height()) < 100&& stopstatus == true) {
				stopstatus = false;
				ajaxUl();
			};
		});
	};
	
});