<?php

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AppVersion;
use think\Request;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/26
 * Time : 13:57
 * Intro:
 */
class Version extends Basic
{
    protected $appVersion;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->appVersion = new AppVersion();
    }

    public function index()
    {
        return view("version/index");
    }

    /**
     * 获取最近版本号
     * @return \think\Response
     */
    public function getVersionNo()
    {
        $type = $_POST["type"];
        $versionResult = $this->appVersion->getVersion($type);
        return $this->response("200", "request success", $versionResult);
    }

    /**
     * 获取版本历史记录
     * @return \think\Response
     */
    public function getVersionList()
    {
        return $this->response("200", "request success", $this->appVersion->getVersionList());
    }

    public function addVersion()
    {
        $param["version_no"] = $_POST["version_no"];
        $param["intro"] = $_POST["intro"];
        $param["type"] = $_POST["type"];
        $param["app_path"] = $_POST["app_path"];

        if (!isset($param["version_no"]) || !isset($param["type"])) {
            $this->response("101", "版本号或app类型不能为空");
        }
        if ($param["type"] == 'android' && isset($param["app_path"])) {
            $this->response("101", "安卓请上传安装包");
        }
        $param["create_time"] = date("Y-m-d H:i:s", time());
        $param["update_time"] = date("Y-m-d H:i:s", time());
        $result = $this->appVersion->addVersion($param);
        if ($result['code'] == 200) {
            return $this->response("200", "上传成功", $result["msg"]);
        } else {
            return $this->response("101", $result["msg"]);
        }
    }
}