$(function() {
	$(document.body).show();
	
	var _doc = $(document);
	var _agentId = getUrlParam('agentId');
	var _token = localStorage.getItem('token');
	
	var loadItem = $('#loading_pic');
	var noMoreItem = $('#no_more');
	var zanWuItem = $('#zanwu_data');
	var pageInit = 1; //要从第一页开始
	var stopstatus = true;
	var _zanwuFlag = true; //暂无是否应该出现
	var _loadOverFlag = false; //一个搜索（包含分页）是否结束
	
	var _pingNum = Number(getUrlParam('pingNum'));
	var _fenNum = parseInt(getUrlParam('fenNum'));
	$('#pingjia_fen').html(_fenNum);
	$('.pingfen-area-large').html(dealStar(_fenNum));
	$('#pingjia_shu').html(_pingNum > 99 ? '99+' : _pingNum).attr('data-num',_pingNum);
	
	ajaxUl(scroll);

	function dealStar(_fen) {
		var _htmlTemp = '';
		for(var i = 1; i < 6; i++) {
			if(i < _fen + 0.5) {
				_htmlTemp += '<small class="small-active"></small>';
			} else if(i == _fen + 0.5) {
				_htmlTemp += '<small class="small-active-guodu"></small>';
			} else {
				_htmlTemp += '<small></small>';
			}
		};
		return _htmlTemp;
	};

	function dealStarText(_fen) {
		if(_fen >= 4) {
			return '非常推荐';
		} else if(_fen >= 3) {
			return '很好';
		} else if(_fen >= 2) {
			return '一般';
		} else if(_fen >= 1) {
			return '很差';
		} else {
			return '非常差';
		};
	};
	
	function dealTimeKf(str){
		if(str === '' || str === null || str === undefined ){
			return '';
		}else{
			return str.split('-')[0] + '-' + str.split('-')[1];
		}
	};

	function ajaxUl(fn){
		$.ajax({
			type: 'get',
			url: ServerHost + '/api/commentAndDeal',
			timeout: 30000,
			dataType: 'json',
			data: {
				'agent_id': _agentId,
				'type': 1,
				'pageNo': pageInit,
				'pageSize': 10,
				'AuthToken': _token
			},
			beforeSend: function() {
				loadItem.show();
				noMoreItem.hide();
				zanWuItem.hide();
			},
			success: function(data) {
				if(typeof data === 'object') {
					if(data['code'] == 200) {
						//成交列表
						if(data['data']['evaluate'] && data['data']['evaluate'].length > 0) {
							_zanwuFlag = false;
							stopstatus = true;
							pageInit++; //页数+1
							var _html = "";
							$.each(data['data']['evaluate'], function(i, item) {
								_html += '<li><div class="li-top-area oh"><figure class="li-top-area-left fl"><div class="oh fl"><img src="{6}"  onerror="javascript:this.src=\'{7}\'" class="fl"></div><figcaption class="oh fl"><p>{0}</p><div class="oh"><div class="pingfen-area fl">{1}</div><p class="fl">{2}</p></div></figcaption></figure><div class="li-top-area-right fr">{3}</div></div><div class="li-bottom-area"><h3>{4}</h3><p>{5}</p></div></li>'.stringFormatObj({
									'0': $.trim(item['user_nick']) == ''?'昵称暂无':item['user_nick'],
									'1': dealStar(item['evaluate_grade']),
									'2': dealStarText(item['evaluate_grade']),
									'3': item['created'],
									'4': (item['receptiontime'] != ''||item['houserAddress'] != '')?(dealTimeKf(item['receptiontime'])+'在'+item['houserAddress']['address']+'看房'):'暂无看房数据',
									'5': item['evaluate_content'],
									'6': location.protocol+'//'+item['user_pic'],
									'7': ServerHost+'/app/images/ic_default_headpic.png'
								});
							});
							$('.pingjia-list-area>ul').append(_html);
							if(data['data']['evaluate'].length < 10) {
								stopstatus = false;
								_loadOverFlag = true;
							};
							fn && fn();
						} else {
						};
					} else {
						layerTipsX(data['msg']);
					};
				} else {
					layerTipsX('数据错误');
				};
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				layerTipsX('error');
			},
			complete: function(xhr, textStatus) {
				(textStatus === 'timeout') && layerTipsX('请求超时');
				loadItem.hide();
				if(_zanwuFlag) {
					zanWuItem.show();
				} else {
					_loadOverFlag && noMoreItem.show();
				};
			}
		});
	};
	
	//滚动加载更多，目前没有启用
	function scroll(){
		$(window).scroll(function(){
			var _this = $(this);
			if(Math.max($(document).height() - _this.scrollTop() - _this.height()) < 100&& stopstatus == true) {
				stopstatus = false;
				ajaxUl();
			};
		});
	};
});