<?php

namespace app\model;



use think\Db;

class GHouses extends BaseModel
{
    protected $table = 'g_houses';

    /**
     * 通过id获取商铺详情
     *
     * @param $id
     * @return array|false|\PDOStatement|string|\think\Model
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseById($id) {
        $fields = 'a.*,b.fee_rule,internal_item_advantage,external_item_advantage,tiny_brochure_url,auditorium,traffic,
                   enter_num,do_business_date,start_business_date,singn_rule,landlord_phone';
        $data = $this->alias('a')->field($fields)
            ->join('g_houses_ext b','a.id = b.house_id', 'left')
            ->where('a.id',$id)
            ->find();
        $data = $data->toArray();

        $img = new GHousesImgs();
        $img_data = $img->field('id,img_type,img_name')
            ->where('img_status = 0 AND house_id = '.$id)
            ->select();

        foreach ($img_data as $k=>$v) {
            switch ($v->img_type) {
                case 1 :
                    $data['cover'] = $v;break;
                case  2 :
                    $data['slide_show'][$k] = $v;break;
                default :
                    $data['plan'][$k] = $v;
            }
        }
        return $data;
    }

    /**
     * 楼盘列表
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param string $field
     * @param string $params
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        $data = $this->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();

        foreach ($data as $k => $v) {
            $result[$k] = $v->getData();
            $rsult[$k]['dish'] = Db::table('g_houses_to_agents')->where('houses_id',$result[$k]['house_id'])->select();
        }
        return $result;
    }
}
