<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/17
 * Time: 15:44
 */

namespace app\model;


use think\Model;

class BaseModel extends Model
{
    /**
     * 记录总数
     *
     * @param $params
     * @return int|string
     */
    public function getTotal($params)
    {
        return  $this->where($params)->count();
    }

    /**
     * 列表
     *
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @return type
     */
    public function getList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        return $this->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

}