<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/17
 * Time: 13:46
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\GHouses;
use app\model\GHousesExt;
use app\model\GHousesImgs;
use app\model\HouseInfos;


class Houses extends Basic
{
    public function index() {
        return view('houseList');
    }

    /**
     * 新增和编辑商铺
     *
     * @return \think\response\View
     * @throws \Exception
     * @throws \think\exception\PDOException
     */
    public function edit() {
        $result['code'] = 200;
        $result['msg'] = '';
        $params = $this->request->param();
        if ($this->request->isPost()) {
            $date = date('Y-m-d H:i:s');

            if ($params['id']) {
                $params['update_time'] = $date;
            }

            $house = new GHouses();
            $house->startTrans();

            //新增或编辑
            if ($params['id'] == '') {
                $house_id = $house->allowField(true)->save($params);
            } else {
                $house_id = $house->allowField(true)->isUpdate(true)->save($params, ['id' => $params['id']]);
            }
            $params['house_id'] = $house_id;
            $house_ext = new GHousesExt();

            if ($params['start_business_date']) {
                $params['start_business_date'] = date('Y-m-d H:i:s' , strtotime($params['start_business_date']));
            }

            //新增或编辑根据id
            if ($params['id'] == '') {
                $house_ext->allowField(true)->save($params);
            } else {
                $house_ext_data = $house_ext->field('id')->where('house_id',$params['id'])->find();
                $house_ext->allowField(true)->isUpdate(true)->save($params, ['id' => $house_ext_data['id']]);
            }

            /***保存图片 hujun 2018.1.19 start***/
            $house_img = new GHousesImgs();
            if ($params['id'] == '') {
                $house_img->add($params, $house_id);
            } else {
                $house_img->edit($params, $house_id);
            }
            /***保存图片 hujun 2018.1.19 end***/
            if ($house_id) {
                $house->commit();
                $return = $this->response($result['code'], $result['msg']);
            } else {
                $house->rollback();
                $return = $this->response(101, $result['msg']);
            }
        } elseif ($params['id']){

            //获取商铺详情
            $house = new GHouses();
            $result['data'] = $house->getHouseById($params['id']);
            $return = $this->response($result['code'], $result['msg'], $result['data']);
        } else {

            //商铺添加页面
            $return = view('edit');
        }
        return $return;
    }

    /**
     * 获取商铺列表
     *
     * @return \think\Response
     */
    public function getHouseList() {
        $data['status'] = 200;
        $data['msg']    = '';
        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $house = new GHouses();
        $where = 'status <> 2';
        $fields = '';
        $data['data']['list'] = $house->getHouseList($pageNo, $pageSize, 'id DESC', $fields, $where);
        $data['data']['total'] = $house->getTotal($where);
        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    public function del() {

    }
}