<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2017/12/22
 * Time: 14:44
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\AAgents;
use app\model\Agents;

class Broker extends Basic
{

    /**
     * 获取经纪人列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getBroker() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['code'] = '';
        $data['msg']  = '';
        $params = $this->request->param();

        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 10 : $params['pageSize'];

        if ($params['phone']) {
            $where = 'phone like "'.$params['phone'].'%" or realname like "'.$params['phone'].'%"';
        }

        if ($where) {
            $agent  = new Agents();
            $field  = 'id,father_id,realname,phone';
            $data['data'] = $agent->getAgents($pageNo, $pageSize, '', $field, $where);
        } else {
            $data['msg'] = '没有该楼盘信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 获取经纪人列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getBroker_new() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';
        $params = $this->request->param();

        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 10 : $params['pageSize'];

        if ($params['phone']) {
            $where = 'phone like "'.$params['phone'].'%" or name like "'.$params['phone'].'%"';
        }

        if ($where) {
            $agent  = new AAgents();
            $field  = 'id,name,phone';
            $data['data'] = $agent->getList($pageNo, $pageSize, '', $field, $where);
        } else {
            $data['msg'] = '没有经纪人信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }
}