<?php
/**
 * Created by PhpStorm.
 * User: hujun
 * Date: 2018/1/16
 * Time: 13:51
 */

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AuthGroup;
class Auth extends Basic
{
    /**
     * 权限列表页
     * 
     * @return type
     */
    public function index(){
        return view('index');
    }
    
    /**
     * 角色编辑
     */
    public function roleedit() {
        return view('roleedit');
    }

    /**
     * 权限分配
     * 
     * @param type $group_id
     */
    public function access($group_id = 0) {
        return view('access');
    }

    /**
     * 用户组授权用户列表
     * 
     * @param type $group_id
     */
    public function accessUser($group_id = 0) {
        return view('accessUser');
    }

    public function getAuth() {
        $data['status'] = 200;
        $data['msg'] = '';

        $params = $this->request->param();
        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];
        $auth_group = New AuthGroup();
        $where = 'status <> 0';
        $data['list'] = $auth_group->getList($pageNo, $pageSize, '','*', $where);
        $data['total'] = $auth_group->getTotal($where);

        return $this->response(200, '', $data);
    }
   
}