<?php

namespace app\api\controller;

use app\api\extend\Basic;
use app\model\Evaluate;
use app\model\HouseImgs;
use app\model\HouseInfos;
use app\model\JournalAccounts;
use app\model\SubletModel;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/12
 * Time : 17:24
 * Intro: 我的交易记录
 */
class TradeLog extends Basic
{

    protected $journalAccountsMode;
    protected $dbImg;
    protected $evaluateMode;
    protected $houseInfoModel;
    protected $subletModel;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->journalAccountsMode = new JournalAccounts();
        $this->dbImg = new HouseImgs();
        $this->houseInfoModel = new HouseInfos();
        $this->evaluateMode = new Evaluate();
        $this->subletModel = new SubletModel();
    }

    /**
     * 获取交易记录
     * @return \think\Response
     */
    public function getTradeList()
    {
        $params = $this->params;
      /*  $params = array(
            "user_id" => "4",
            "phone" => "18521095110",
            "pageNo" => 1,
            "pageSize" => 15,
        );*/

        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];
        if (!isset($params["user_id"])) {
            return $this->response("101", "userId不能为空");
        }
        if (!isset($params["phone"])) {
            return $this->response("101", "phone不能为空");
        }
        $order_ = 'a.created desc';

        $field = "min(a.id) as id,a.tradecode,a.created as singntime,b.phpone,b.house_id,b.agent_id";

        $result = $this->journalAccountsMode->getJournalAccountsList($pageNo, $pageSize, $order_, $field, $params);
        if (count($result) <= 0) {
            return $this->response("200", "请求数据为空");
        }
        foreach ($result as $key => $val) {
            $houseInfo = $this->houseInfoModel->getHouseDetail("room_num_left,title", array( "id" => $val["house_id"] ));
            $result[$key]["room_num_left"] = $houseInfo["room_num_left"];
            $result[$key]["title"] = $houseInfo["title"];
            $result[$key]["api_path"] = IMG_PATH;
            $imgParam["house_id"] = $val["house_id"];
            $imgParam["imgtype"] = 1; //默认主图
            $result[$key]["images"] = $this->dbImg->getHouseImages($imgParam, 1);
            $evaluateResult = $this->evaluateMode->getIsEvaluate(20, $val["id"], $params["user_id"]);
            $result[$key]["is_evaluate"] = count($evaluateResult) > 0 ? 1 : 0;
            //todo 是否以上架
            $subParam["user_id"] = $params["user_id"];
            $subParam["house_id"] = $val["house_id"];
            $subletResult = $this->subletModel->getSubletByHoseId($subParam);
            if (count($subletResult) > 0) {
                $result[$key]["is_added"] = $subletResult[0]["status"];
            } else {
                $result[$key]["is_added"] = -1;
            }
        }
        return $this->response("200", "request", $result);

    }

}