<?php

namespace app\model;

use think\Model;
use think\helper\Time;
use think\Db;
class JournalAccounts extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'Journalaccounts';
    protected $db;

    function __construct()
    {
        $this->db = Db($this->table);
    }

    /**
     * 获取月均价
     * @return float
     */
    function getTurnover()
    {
        $timeArr = Time::lastWeek();
        $signStartTime = date("Y-m-d H:i:s", $timeArr[0]);
        $signEndTime = date("Y-m-d H:i:s", $timeArr[1]);
        $where_['singntime'] = array( "between", array( $signStartTime, $signEndTime ) );
        return $this->db
            ->where($where_)
            ->count("id");
    }
    
    /**
     * 成交记录列表
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $agent_id
     * @return type
     */
    public function getJournalHouseInfo($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $agent_id = '') {

        if ($agent_id) {
            $result = $this->field('a.house_id')->alias('j')
                    ->join('applies a','j.apply_id = a.id')
                    ->where('a.agent_id', $agent_id)
                    ->where('j.transaction_status = 3')
                    ->group('j.apply_id')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        } else {
            $result = $this->field('a.house_id')->alias('j')
                    ->join('applies a', 'j.apply_id = a.id')
                    ->where('a.agent_id', $agent_id)
                    ->where('j.transaction_status = 3')
                    ->group('j.apply_id')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        }
        
        $fields_houinfo = 'id,title,rent_type,price,room_area,room_area2,shangpu_type'; 
        //查找商铺或街铺的名字和图片
        foreach ($result as $key => $value) {
            $data[$key] = Db::table('houseinfos')->field($fields_houinfo)->where('id',$value['house_id'])->find();
            $img = Db::table('houseimgs')->field('imagename')
                    ->where('house_id', $value['house_id'])->where('imgtype',1)->find();
            $data[$key]['img'] = $img['imagename'];
        }
        
        return $data;
    }
}
