<?php

namespace app\model;

use think\Model;

class Evaluate extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_evaluate';

    /**
     * 获得评价列表
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $agent_id //获得经纪人的评价
     * @return type
     */
    public function getEvaluate($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $agent_id = '') {
    
        if ($agent_id) {
            $result = $this->field($field)
                    ->where('agents_id',$agent_id)
                    ->where('is_show',0)
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
      
        } else {
            $result = $this->field($field)
                    ->where('is_show', 0)
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        }

        $sign = new EvaluateSign();

        foreach ($result as $k=>$v) {
            $data[$k]   = $v->getData(); 
            if ($v['evaluate_sign']) {
                 $data[$k]['evaluate_sign'] = $sign->field('sign_name,point_obj')
                         ->where('id', 'in', $v['evaluate_sign'])
                         ->where('is_del',0)
                         ->select();
            }          
        }
        
        return $data;
    }
}
