<?php

namespace app\model;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/7
 * Time : 17:50
 * Intro:
 */
use think\Db;
use think\Model;
use think\Log;

class BannerModel extends Model
{
// 设置当前模型对应的完整数据表名称
    protected $table = 'u_banner';
    protected $db;
    protected $logger;

    function __construct()
    {
        $this->db = Db($this->table);
        $this->logger = new Log();
    }

    /**
     * 新增banner修改banner
     * @param $param
     * @return array
     */
    function addOrUpdate($param)
    {
        $banner = $this->db;
        $arr = array();

        if (isset($param['title'])) {
            $arr["title"] = $param['title'];
        }
        if (isset($param['pic_path'])) {
            $arr["pic_path"] = $param['pic_path'];
        }
        if (isset($param['url'])) {
            $arr["url"] = $param['url'];
        }
        if (isset($param['sort'])) {
            $arr["sort"] = $param['sort'];
        }
        if (isset($param['title'])) {
            $arr["is_show"] = $param['is_show'];
        }


        if (isset($param['id'])) {
            $result = $this->db
                ->where("id=" . $param['id'])
                ->select();
            if (count($result) > 0) {
                $arr["id"] = $param["id"];
            } else {
                return [ "code" => "101", "msg" => "数据不存在" ];
            }
        } else {
            $arr["create_time"] = time();
        }
        Db::startTrans();
        try {
            $id = $banner->save($arr);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }

    }

    /**
     * 逻辑删除，不显示在前端
     * @param $param
     * @return array
     */
    function upIsShow($param)
    {
        //$this->logger->info('日志信息');
        $banner = $this->db;
        $arr = array(
            "id" => $param['id'],
            "is_show" => $param['is_show'],
            "update_time" => time()
        );
        var_dump($arr);exit;
        Db::startTrans();
        try {
            $id = $banner->save($arr);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "删除失败，数据异常" ];
        }
    }

    /**
     * bannerList
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @return mixed
     */
    function getBannerList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params)
    {
        return $this->db
            ->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }
}