<?php

namespace app\api\controller;
use app\api\extend\Basic;
use app\model\Agents;
use app\model\Evaluate;
use app\model\EvaluateSign;
use app\model\JournalAccounts;
/**
 * Description of Agents
 *
 * @user :hujun
 * @date :2017-12-11
 * @time :11:15:05
 * Intro :
 */
class Broker extends Basic{
    
    /**
     * 获取当前商铺或街铺的经纪人
     * 
     * @return type
     */
    public function index() {
        $params = $this->params;
        $data['status'] = 101;      
        $data['data']   = '';
        if ($params['house_id']) {
            
            $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
            $pageSize = empty($params['pageSize']) ? PAGESIZE : $params['pageSize'];
            
            $agents = new Agents();
            $data['msg']  = '';
            $data['data'] = $agents->getUser($pageNo, $pageSize, '', 'id,realname,phone', '', $params['house_id']);
            $data['data']['pageNo']   = $pageNo;
            $data['data']['pageSize'] = $pageSize;
        } else {
            $data['msg']  = 'house_id 为空';            
        }
        return $this->response($data['status'], $data['msg'], $data['data'] );
    }
    
    /**
     * 评价经纪人
     * 
     * @return type
     */
    public function appraiser() {
        $params = $this->params;
        $data['status'] = 101;
        $data['data']   = '';
        $data['msg']    = '';
        if (empty($params['agents_id'])) {
            return $this->response($data['status'], 'agents_id is null');
        }
        
        if (empty($params['house_id'])) {
            return $this->response($data['status'], 'house_id is null');
        }
        if (empty($params['user_id'])) {
            return $this->response($data['status'], 'user_id is null');
        }
        if (empty($params['record_id'])) {
            return $this->response($data['status'], 'record_id is null');
        }        
        if (empty($params['source'])) {
            return $this->response($data['status'], 'source is null');
        }        
        
        $date = date('Y-m-d H:i:s');
        $id_arr = array();
        if (isset($params['sign_name'])) {
            $evaluate_sign = new EvaluateSign();
            foreach ($params['sign_name'] as $v) {
                $sign_data[] = [
                    'sign_name' => $v,
                    'point_obj' => 0,
                    'is_del' => 0,
                    'create_time' => $date,
                    'update_time' => $date,
                ];                
            }
            $resutl = $evaluate_sign->saveAll($sign_data);
            foreach ($resutl as $vv) {
                $id_arr[] = $vv->id;
            }
        }

        $evaluate = new Evaluate();
        $evaluate->save([
            'user_id'   => $params['user_id'],
            'agents_id' => $params['agents_id'],
            'source'    => $params['source'],
            'record_id' => $params['record_id'],
            'evaluate_grade'   => $params['evaluate_grade'],
            'evaluate_content' => $params['evaluate_content'],
            'evaluate_sign'    => implode(',', $id_arr),
            'create_time'  => $date,
            'update_time' => $date,
            'is_show'  => 0,
            'house_id' => $params['house_id']
        ]);
        

        $data['data'] = ['id'=> $evaluate->id];
          
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
    
    
    /**
     * 查询评论和成交记录
     * 
     * @return type
     */
    public function  commentAndDeal() {
        $params = $this->params;
        $data['status'] = 200;
        $data['data']   = '';
        $data['msg']    = '';
        
        if ($params['agent_id']) {
            $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
            $pageSize = empty($params['pageSize']) ? PAGESIZE : $params['pageSize'];
            
            $evalutate = new Evaluate();
            $journal  = new JournalAccounts();
            
            $fields_evaluate = 'evaluate_grade,evaluate_content,evaluate_sign';

            switch ($params['type']) {
                case 0:
                    //评价列表信息
                    $result['evaluate'] = $evalutate->getEvaluate($pageNo, $pageSize, 'id desc', $fields_evaluate, '', $params['agent_id']);
                    //成交记录
                    $result['journalAccounts'] = $journal->getJournalHouseInfo($pageNo, $pageSize, 'j.id desc', $fields, 'j.transaction_status = 3', $params['agent_id']);
                    $data['data'] = $result;
                    break;
                case 1:
                    //评价列表信息
                    $result['evaluate'] = $evalutate->getEvaluate($pageNo, $pageSize, 'id desc', $fields_evaluate, '', $params['agent_id']);
                    $data['data'] = $result;
                    break;
                case 2:
                    //成交记录
                    $result['journalAccounts'] = $journal->getJournalHouseInfo($pageNo, $pageSize, '', '', '', $params['agent_id']);
                    $data['data']   = $result;
                    break;
                default:
                    $data['stauts'] = 101;
                    $data['msg']    = 'type is null';
                    break;
            }
        } else {
            $data['msg'] = 'agent_id is null';
        }
        
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
}
