define(['doT', 'jquery'], function (doT, $) {
    var init = {
        doTinit: function () {
            doT.templateSettings = {
                evaluate: /\[\%([\s\S]+?)\%\]/g,
                interpolate: /\[\%=([\s\S]+?)\%\]/g,
                encode: /\[\%!([\s\S]+?)\%\]/g,
                use: /\[\%#([\s\S]+?)\%\]/g,
                define: /\[\%##\s*([\w\.$]+)\s*(\:|=)([\s\S]+?)#\%\]/g,
                conditional: /\[\%\?(\?)?\s*([\s\S]*?)\s*\%\]/g,
                iterate: /\[\%~\s*(?:\%\]|([\s\S]+?)\s*\:\s*([\w$]+)\s*(?:\:\s*([\w$]+))?\s*\%\])/g,
                varname: 'it',
                strip: true,
                append: true,
                selfcontained: false
            };
        }
    };
    init.doTinit();
    var pageId = $('.page-load').attr('id');
    loadJSFile(pageId);
    function loadJSFile(pageId) {
        require(['app/' + pageId], function (dataObj) {
            dataObj.init();
        });
    }

});



