define (['doT', 'text!temp/district_template_tpl.html', 'css!style/home.css','pagination','bootstrapJs'], function (doT, template) {
    district = {
        pageNo: 1, /*第几页*/
        pageSize: 10, /*每页显示多少条*/
        init: function () {
            //初始化dot
            $ ("body").append (template);
            district.getList ();
            district.event ();
        },
        event: function () {
            $ (document).delegate ("#search", "click", function () {//点击搜索
                district.getList(1);
            });

        },
        getList: function (pageNo) {
            district.pageNo   = pageNo;
            var params    = {};
            params.pageNo   = district.pageNo;
            params.pageSize = district.pageSize;
            params.search = $("input[name='search']").val();
            $.ajax ({
                url: '/index/getDistrictList',//列表数据
                type: 'GET',
                async: true, 
                data: params,
                dataType: 'json',
                success: function (data) {
                    var temp = document.getElementById ('district_list_tpl').innerHTML;
                    var doTtmpl = doT.template (temp);
                    $ ("#district_list").html (doTtmpl (data.data.list));
                    /*分页代码*/
                    $ ("#pagediv").pagination ({
                        length: data.data.total,
                        current: pageNo,
                        every: district.pageSize,
                        onClick: function (el) {
                            district.getList (el.num.current);
                        }
                    });
                }
            });
        }
    };
    return district;
});