<?php
namespace app\model;

use think\Db;
use think\Model;


/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2018/2/1
 * Time : 16:02
 * Intro:
 */

class ORefundModel extends Model{

    protected $table = "o_refund";
    private $db_;
    function __construct()
    {
        $this->db_=Db::name($this->table);
    }

    /**
     * 新增退款记录
     * @param $params
     * @return int|string
     */
    public function addRefund($params){
        $refund_arr = [];
        if(isset($params["agent_id"])){
            $refund_arr["agent_id"] = $params["agent_id"];
        }
        if(isset($params["report_id"])){
            $refund_arr["report_id"] = $params["report_id"];
        }
        if(isset($params["order_id"])){
            $refund_arr["order_id"] = $params["order_id"];
        }
        if(isset($params["order_no"])){
            $refund_arr["order_no"] = $params["order_no"];
        }
        if(isset($params["refund_money"])){
            $refund_arr["refund_money"] = $params["refund_money"];
        }
        if(isset($params["name"])){
            $refund_arr["name"] = $params["name"];
        }
        if(isset($params["bank"])){
            $refund_arr["bank"] = $params["bank"];
        }
        if(isset($params["card_no"])){
            $refund_arr["card_no"] = $params["card_no"];
        }
        if(isset($params["remark"])){
            $refund_arr["remark"] = $params["remark"];
        }
        if(isset($params["remark_img"])){
            $refund_arr["remark_img"] = $params["remark_img"];
        }

        $refund_arr["create_time"] = date("Y-m-d H:i:s",time());
        $refund_arr["update_time"] = date("Y-m-d H:i:s",time());

        Db::startTrans();
        try {
            $id = $this->db_->insert($refund_arr);
            Db::commit();
            return $id;
        } catch (\Exception $e) {
            Db::rollback();
            return 0;
        }
    }
}