<?php

namespace app\model;

/**
 * Created by PhpStorm.
 * User: zw
 * Date: 2017/12/21
 * Time: 14:41
 */

use think\Db;
use think\Model;


class FollowUpLogModel extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'o_follow_up_log';
    private $db_;

    function __construct()
    {
        $this->db_ = Db::name($this->table);
    }

    /**
     * 新增跟进
     * @param $params
     * @return int
     */
    public function addFollowUpLog($params)
    {
        $params["create_time"] = date("Y-m-d H:i:s", time());
        $params["update_time"] = date("Y-m-d H:i:s", time());

        Db::startTrans();
        try {
            $this->db_->insert($params);
            Db::commit();
            return 1;
        } catch (\Exception $e) {
            Db::rollback();
            return 0;
        }
    }

    /**
     * 获取跟进数据
     * @param $field_
     * @param $where_
     * @param $order_
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function selectFollowUpList($field_, $where_, $order_)
    {
        if (isset($where_["agent_id"])) {
            $data = $this->db_
                ->field($field_)
                ->where($where_)
                ->order($order_)
                ->select();
        } else {
            $data = $this->db_
                ->field($field_)
                ->where($where_)
                ->order($order_)
                ->limit(1)
                ->select();
        }
        return $data;

    }

}