<?php
//权限规则模型       

namespace app\model;

use think\Model;

class AuthRule extends BaseModel
{
	// 设置完整的数据表（包含前缀）
    // protected $table = 'think_access';

    // 设置数据表（不含前缀）
    // protected $name = 'auth_rule';

	// 设置birthday为时间戳类型（整型）
    // protected $type       = [
    //     'birthday' => 'timestamp',
    // ];




    /**
     * 将格式数组转换为树
     *
     * @param array $list
     * @param integer $level 进行递归时传递用的参数
     */
    private $formatTree; //用于树型数组完成递归格式的全局变量
    private function _toFormatTree($list,$level=0,$title = 'title') {
        foreach($list as $key=>$val){
            $tmp_str=str_repeat("&nbsp;",$level*2);
            $tmp_str.="└";

            $val['level'] = $level;
            $val['title_show'] =$level==0 ? $val[$title]."&nbsp;" : $tmp_str.$val[$title]."&nbsp;";
            // $val['title_show'] = $val['id'].'|'.$level.'级|'.$val['title_show'];
            if(!array_key_exists('_child',$val)){
                array_push($this->formatTree,$val);
            }else{
                $tmp_ary = $val['_child'];
                unset($val['_child']);
                array_push($this->formatTree,$val);
                $this->_toFormatTree($tmp_ary,$level+1,$title); //进行下一层递归
            }
        }
        return;
    }

    public function toFormatTree($list,$title = 'title',$pk='id',$pid = 'pid',$root = 0){
        $list = list_to_tree($list,$pk,$pid,'_child',$root);
        $this->formatTree = array();
        $this->_toFormatTree($list,0,$title);
        return $this->formatTree;
    }



    /**
     * 记录总数
     *
     * @param $params
     * @return int|string
     */
    public function getTotal($params,$as='')
    {
        return  $this->alias($as)->where($params)->count();
    }

//查询不带分页
    public function  authRuleList2( $order = '', $field = '',$join='', $where = ''){
        $data = $this->field($field)
            ->alias('a')
            ->join($join)
            ->where($where)
            ->order($order)
            ->select();
        return $data;
    }

//查询带分页
    public function  authRuleList($p = 1, $pageSize = 15, $order_ = '', $field = '',$join='', $where = ''){
        $data = $this->field($field)
            ->alias('a')
            ->join($join)
            ->where($where)
            ->order($order_)
            ->limit($pageSize)
            ->page($p)
            ->select();
        return $data;
    }
    /**
     *检查重复
     *
     */
    public function repetition($name,$key){
        $r=$this->field($name)
            ->where($name,'=',$key)
            ->select();
        //$this->getLastSql();
        if($r){
            return true;
        }else{
            return false;
        }
    }
    
    public function loginRule($where){
        $r=$this->field('id,name,title,pid')
                ->where($where)
                ->select();
       // $this->getLastSql();
        return $r;
    }

    //更新数据
    public function saveStatus($name,$key,$ids){
        $r = $this->where("id",'in',$ids)->update([$name=>$key]);
        return $r;
    }





}