<?php
/**
 * Created by PhpStorm.
 * User: hu jun
 * Date: 2018/2/5
 * Time: 15:19
 */

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AAgents;
use app\model\ADistrict;
class District extends Basic
{
    /**
     * 部门总监列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getDistrictList () {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';
        $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
        $pageSize = empty($this->params['pageSize']) ? 10 : $this->params['pageSize'];
        $search   = $this->params['search'];
        $agents = new AAgents();
        $field  = 'id,name,create_time,phone,district_id';
        $where   = '';
        $where  .= 'level=40 AND status=0';

        if ($search != NULL) {
            $where .= " AND (phone like '{$search}%' or name like '{$search}%')";
        }

        $data['list'] = $agents->getListDistrict($pageNo, $pageSize, 'id DESC', $field, $where);
        $data['total'] = $agents->getListDistrictTotal($where);
        return $this->response($data['status'], $data['msg'], $data);
    }

    /**
     * 部门总监列表页面
     */
    public function districtList() {
        return view('index');
    }

    /**
     * 添加部门，绑定总监关系
     *
     * @return \think\Response
     * @throws \think\exception\PDOException
     */
    public function addDistrict () {
        if ($this->params['department_name'] || $this->params['agents_id']) {
            $district = new ADistrict();
            $this->data = $district->addDepartmentAgents($this->params, $this->params['agents_id']);
        } else {
            $this->code = 101;
            $this->msg  = 'department or district is null';
        }
        return $this->response($this->code, $this->msg, $this->data);
    }

    /**
     * 根据部门名获取部门列表
     *
     * @return \think\Response
     */
    public function getDistrictListByName() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';

        $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
        $pageSize = empty($this->params['pageSize']) ? 10 : $this->params['pageSize'];
        $where['status'] = 0;
        if ($this->params['district_name']) {
            $where['district_name'] = ['LIKE', $this->params['district_name']. '%'];
        }

        if ($where) {
            $agent  = new ADistrict();
            $field  = 'id,district_name';
            $data['data'] = $agent->getList($pageNo, $pageSize, 'id DESC', $field, $where);
        } else {
            $data['msg'] = '没有部门信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

}