<?php

namespace app\app\controller;

use app\model\AppVersion;
use app\model\HouseImgs;
use app\model\HouseInfos;
use think\Controller;
use think\Response;

class Index
{

    protected $db;
    protected $dbImg;
    protected $appVersion;

    public function __construct()
    {

        $this->db = new HouseInfos();
        $this->dbImg = new HouseImgs();
        $this->appVersion = new AppVersion();
    }

    public function index()
    {
        return view('index/index');
    }

    public function share_detail()
    {
        return view('index/share_detail');
    }

    public function share_register()
    {

      return view('index/share_register');
    }

    public function agent_detail()
    {
        return view('index/agent_detail');
    }

    public function agreement()
    {
        return view('index/agreement');
    }

    public function agreement_app()
    {
        return view('index/agreement_app');
    }
    public function download()
    {
      return view('index/download');
    }
    public function more_pingjia()
    {
        return view('index/more_pingjia');
    }

    public function more_chengjiao()
    {
        return view('index/more_chengjiao');
    }

    /**
     * 楼盘详情
     * @return \think\Response
     */
    public function getShopDetail()
    {
        $id = $_POST["id"] ? $_POST["id"] : $_GET["id"];

        $field = "a.id,a.management_fee,a.title,a.address,a.city,a.room_area,a.room_area2,a.business_area,a.disc,a.disccircles,
        a.sales,a.slotting_fee,a.transfer_fee, a.yetai,a.room_area2,a.shangpu_type,a.is_test,a.sellingpoint,a.singn_rule,
        a.business_date,a.start_business_date,a.opentime,a.has_gas,a.traffic,a.has_moved,a.room_num_left,a.room_num_total,
        a.shangpu_tags,a.carefully_chosen,a.price,a.dish,a.file_path,b.foreign_name,b.address_detail_c,
        b.foreign_advantage";
        $conditions = [];
        if (empty($id)) {
            return $this->response("101", "详情id不能为空");
        }

        $conditions['a.id'] = array( "eq", $id );
        $conditions['a.show_all'] = array( 'eq', 0 ); //只显示公开楼盘

        $result = $this->db->getHouseDetails($field, $conditions);
        if( count($result) > 0){
            $result["api_path"] = IMG_PATH;
            $param["house_id"] = $id;
            $result["images"] = $this->dbImg->getHouseImages($param, 15);
            $param["imgtype"] = 4;//图片类型:1效果图，2实景图，3样板图，4户型图，5交通图
            $result["plan_images"] = $this->dbImg->getHouseImages($param, 4);
            if ($result['room_num_left'] == 0) {
                return $this->response("101", '此楼盘已下架');
            }
        }
        return $this->response("200", 'request success', $result);
    }



    /**
     * 获取最近版本号 安卓
     * @return \think\Response
     */
    public function getVersionNo()
    {
        $versionResult = $this->appVersion->getVersion("android");
        return $this->response("200", "request success", $versionResult);
    }


    /**
     * 输出返回数据
     * @param string $msg 提示消息内容
     * @param string $code 业务状态码
     * @param mixed $data 要返回的数据
     * @param string $type 返回类型 JSON XML
     * @return Response
     */
    public function response($code = 'SUCCESS', $msg, $data = [], $type = 'json')
    {
        $result = [ 'code' => $code, 'msg' => $msg, 'data' => $data, 'type' => strtolower($type) ];
        return Response::create($result, $type);
    }
}
