<?php

namespace app\api_broker\service;

use app\model\OBargainModel;
use app\model\OPayLogModel;


/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2018/2/1
 * Time : 13:58
 * Intro:
 */
class OrderLogService
{
    private $payLogModel;
    private $bargainModel;

    function __construct()
    {
        $this->payLogModel = new OPayLogModel();
        $this->bargainModel = new OBargainModel();
    }

    /**
     *批量插入收款记录
     * @param $agent_id
     * @param $report_id
     * @param $order_id
     * @param $order_no
     * @param $collecting_bill
     * @param $house_number
     * @param $industry_type
     * @param $remark
     * @param $transfer_img
     * @return int
     */
    public function addCollectingBill($agent_id, $report_id, $order_id, $order_no, $collecting_bill, $house_number,
                                      $industry_type, $remark, $transfer_img)
    {
        $bill_arr = [];
        foreach ($collecting_bill as $collecting) {
            if (isset($collecting["type"]) && isset($collecting["pay_type"]) && isset($collecting["money"])) {
                array_push($bill_arr, $this->collectingBillBin($collecting, $agent_id, $report_id, $order_id, $order_no,
                    $house_number, $industry_type, $remark, $transfer_img));
            }
        }
        //todo if bill_arr not null, save database table
        if (!empty($bill_arr)) {
            return $this->payLogModel->addPayLog($bill_arr);
        }
        return 0;
    }

    private function collectingBillBin($collecting_arr, $agent_id, $report_id, $order_id, $order_no, $house_number,
                                       $industry_type, $remark, $transfer_img)
    {

        $arr["report_id"]     = $report_id;
        $arr["order_no"]      = $order_no;
        $arr["order_id"]      = $order_id;
        $arr["agent_id"]      = $agent_id;
        $arr["type"]          = $collecting_arr["type"];
        $arr["pay_type"]      = $collecting_arr["pay_type"];
        $arr["money"]         = $collecting_arr["money"];
        $arr["house_number"]  = $house_number;
        $arr["industry_type"] = $industry_type;
        $arr["remark"]        = $remark;
        $arr["transfer_img"]  = $transfer_img;
        $arr["create_time"]   = date("Y-m-d H:i:s", time());
        $arr["update_time"]   = date("Y-m-d H:i:s", time());
        return $arr;
    }


    /**
     * 批量插入成交报告
     * @param $submit_agent_id
     * @param $report_id
     * @param $order_id
     * @param $order_no
     * @param $trade_type
     * @param $price
     * @param $commission
     * @param $commission_arr
     * @return int
     */
    public function addBargain($submit_agent_id, $report_id, $order_id, $order_no, $trade_type, $price, $commission, $commission_arr)
    {
        $bargain_arr = [];
        foreach ($commission_arr as $commission_val) {
            if (isset($collecting["role"]) && isset($collecting["agent_id"]) && isset($collecting["scale"]) && isset($collecting["scale_fee"])) {
                array_push($bargain_arr, $this->bargainBin($commission_val, $submit_agent_id, $report_id, $order_id,
                    $order_no, $trade_type, $price, $commission));
            }
        }
        //todo if bill_arr not null, save database table
        if (!empty($bargain_arr)) {
            return $this->bargainModel->addBargain($bargain_arr);
        }
        return 0;
    }

    private function bargainBin($commission_val, $submit_agent_id, $report_id, $order_id, $order_no, $trade_type, $price, $commission)
    {
        $arr["report_id"]       = $report_id;
        $arr["order_no"]        = $order_no;
        $arr["order_id"]        = $order_id;
        $arr["submit_agent_id"] = $submit_agent_id;
        $arr["trade_type"]      = $trade_type;
        $arr["price"]           = $price;
        $arr["commission"]      = $commission;
        $arr["role"]            = $commission_val["role"];
        $arr["agent_id"]        = $commission_val["agent_id"];
        $arr["scale"]           = $commission_val["scale"];
        $arr["scale_fee"]       = $commission_val["scale_fee"];
        $arr["create_time"]     = date("Y-m-d H:i:s", time());
        $arr["update_time"]     = date("Y-m-d H:i:s", time());
        return $arr;
    }

}