<?php

namespace app\api_broker\controller;

use app\api_broker\extend\Basic;
use app\api_broker\service\ReportService;
use app\model\FollowUpLogModel;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2018/1/24
 * Time : 14:24
 * Intro:
 */
class Report extends Basic
{
    private $service_;
    private $fulModel;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->service_ = new ReportService();
        $this->fulModel = new FollowUpLogModel();
    }

    /**
     * 报备
     * @return \think\Response
     */
    public function report()
    {
        $params = $this->params;
        if (!isset($params['report_agent_id']) || !isset($params['report_store_id']) || !isset($params['user_id']) ||
            !isset($params['house_ids']) || !isset($params['vehicle'])) {
            return $this->response("101", "请求参数错误");
        }

        /* $params = array(
             "report_agent_id"  => 1,//报备经纪人id
             "report_store_id"  => 1,//门店id
             "user_id"          => 1,//用户id
             "house_ids"        => "1,2,3",//楼盘id
             "vehicle"          => 10,//交通工具
             "intro"            => "123123123",//备注
             "predict_see_time" => date("Y-m-d H:i:s", time()),//预计到看时间
         );*/
        //todo 检查经纪人状态 basic类做

        //todo 验证用户id是否正常

        $agent_id         = $params["report_agent_id"];
        $store_id         = $params["report_store_id"];
        $user_id          = $params["user_id"];
        $house_ids        = $params["house_ids"];
        $vehicle          = $params["vehicle"];
        $intro            = $params["intro"];
        $predict_see_time = $params["predict_see_time"];

        $is_ok = $this->service_->verifyReport($agent_id, $store_id, $user_id, $house_ids, $vehicle, $intro, $predict_see_time);
        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        } else {
            return $this->response("101", "save exception");
        }


    }

    /**
     * 根据报备的编号  进场
     * @return \think\Response
     */
    public function marchInByOrderId()
    {
        return $this->response();
    }

    /**
     * 新增跟进
     * @return \think\Response
     */
    public function addFollowUp()
    {
        /*$params = array(
            "report_id" => 1,
            "agent_id" => 12,
            "user_type" =>"1,2", // 用户类型
            "decision_maker" =>"zhangsan",// 第一决策人
            "industry_type" =>"1,2",//租商铺做什么
            "area_requirement" =>"1,2",//面积要求
            "price_requirement" =>"1,2", //价格要求
            "province" =>"1,2", //省
            "city" =>"1,2",//市
            "district" =>"1,2",//区
            "business_area" =>"1,2",//商圈
            "other_area" =>"1,2",//其他地区
            "explain" =>"1,2",//备注
            "explain_img" =>"1,2"//备注图
        );*/

        $params = $this->params;
        if (!isset($params['report_id']) || !isset($params['agent_id']) || !isset($params['user_type']) ||
            !isset($params['industry_type']) || !isset($params['area_requirement']) || !isset($params['price_requirement'])) {
            return $this->response("101", "请求参数错误");
        }

        $is_ok = $this->fulModel->addFollowUpLog($params);
        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        } else {
            return $this->response("101", "request error");
        }

    }

    /**
     * 获取跟进记录列表
     * @return \think\Response
     */
    public function getFollowUpList()
    {
        /* $params = array(
             "report_id" => 1,// 报备id
             "agent_id"  => 1,//非必填  经纪人id 没有就获取最新一条跟进记录
         );*/
        $params = $this->params;
        if (!isset($params["report_id"])) {
            return $this->response("101", "请求参数错误");
        }
        $field_ = "id,report_id,agent_id,user_type,decision_maker,industry_type,area_requirement,price_requirement,province
        ,city,district,business_area,other_area,explain,explain_img,create_time,update_time";

        $order_ = "crate_time desc";

        $where_              = [];
        $where_["report_id"] = $params["report_id"];
        if (isset($params["agent_id"])) {
            $where_["agent_id"] = $params["agent_id"];
        }
        $result = $this->fulModel->selectFollowUpList($field_, $where_,$order_);
        if (count($result) > 0) {
            return $this->response("200", "request success", $result);
        } else {
            return $this->response("300", "not fund list", []);
        }
        return $this->response("101", "request error");

    }
}