<?php

namespace app\api_broker\controller;

use app\api_broker\extend\Basic;
use app\api_broker\service\OrderLogService;
use app\model\OMarchInModel;
use app\model\ORefundModel;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2018/1/31
 * Time : 14:46
 * Intro:
 */
class OrderLog extends Basic
{

    private $o_march_in_model;
    private $o_refund_model;
    private $service_;

    function __construct()
    {
        $this->o_march_in_model = new OMarchInModel();
        $this->o_refund_model   = new ORefundModel();
        $this->service_         = new OrderLogService();
    }


    /**
     * 进场
     * @return \think\Response
     */
    public function marchIn()
    {
        $params = $this->params;
        if (!isset($params["march_in_area"]) || !isset($params["reception_id"]) || !isset($params["report_id"])
            || !isset($params["order_id"]) || !isset($params["order_no"])) {
            return $this->response("101", "请求参数错误");
        }
        /* $params = array(
             "reception_id" => 1,//带看经纪人id
             "report_id" => 1,//报备id
             "order_id" =>1, //关联order表id
             "order_no" =>1, //订单no
             "march_in_remark" =>1, //进场备注
             "march_in_img" =>1, //备注图片
             "march_in_area" =>1, //进场地址
         );*/
        $is_ok = $this->o_march_in_model->addMarchIn($params);
        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        } else {
            return $this->response("101", "request faild");
        }
    }

    /**
     * 收款
     * @return \think\Response
     */
    public function collectingBill()
    {
        $params = $this->params;

        if (!isset($params["agent_id"]) || !isset($params["report_id"]) || !isset($params["order_id"]) || !isset($params["order_no"])
            || !isset($params["collecting_bill"]) || !isset($params["collecting_bill"][0]["type"]) || !isset($params["house_number"])
            || !isset($params["industry_type"])) {
            return $this->response("101", "请求参数错误");
        }
        /*     $params       = array(
                 "agent_id"  => 1,//收款经纪人id
                 "report_id" => 1,//报备id
                 "order_id"  => 1, //关联order表id
                 "order_no"  => 1, //订单no

                 // `type`  '付款类型 10意向金 20定金 30保管金 40押金 50 租金 60 进场费 70转让费 80其他',
                 //`pay_type`  '支付方式 10支付宝 20 微信 30pos机器 40转账 50现金',
                 // `money`  '入账金额 存分',

                 "collecting_bill" => [ [ "type" => 10, "pay_type" => 10, "money" => 1100 ], [ "type" => 10, "pay_type" => 10, "money" => 1200 ] ],
                 "house_number"    => "3301号",
                 "industry_type"   => "asdasdasd",
                 "remark"          => "没什么备注",
                 "transfer_img"    => "12312312312"
             );*/
        $remark       = isset($params["remark"]) ? $params["remark"] : "";
        $transfer_img = isset($params["transfer_img"]) ? $params["transfer_img"] : "";

        $is_ok = $this->service_->addCollectingBill($params["agent_id"], $params["report_id"], $params["order_id"], $params["order_no"],
            $params["collecting_bill"], $params["house_number"], $params["industry_type"], $remark, $transfer_img);

        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        }
        return $this->response("101", "request faild");
    }

    /**
     * 新增退款申请
     * @return \think\Response
     */
    public function refund()
    {
        $params = $this->params;

        if (!isset($params["agent_id"]) || !isset($params["report_id"]) || !isset($params["order_id"]) || !isset($params["order_no"])
            || !isset($params["refund_money"])) {
            return $this->response("101", "请求参数错误");
        }
        /* $params = array(
             "agent_id"     => 1,//退款经纪人id
             "report_id"    => 1,//报备id
             "order_id"     => 1, //关联order表id
             "order_no"     => 1, //订单no
             "refund_money" => 1200, //退款金额 存分
             "name"         => "qweqwe", //收款人姓名
             "bank"         => "asdasdasd", //收款人银行
             "card_no"      => "123123123123", //银行卡号
             "remark"       => "没什么备注",
             "remark_img"   => "12312312312"
         );*/
        $is_ok = $this->o_refund_model->addRefund($params);
        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        }
        return $this->response("101", "request faild");
    }

    /**
     * 成交报告
     * @return \think\Response
     */
    public function bargain()
    {
        $params = $this->params;

        if (!isset($params["submit_agent_id"]) || !isset($params["report_id"]) || !isset($params["order_id"]) || !isset($params["order_no"])
            || !isset($params["trade_type"]) || !isset($params["price"]) || !isset($params["commission"])
            || !isset($params["commission_arr"][0]["role"]) || !isset($params["commission_arr"][0]["agent_id"])
            || !isset($params["commission_arr"][0]["scale"]) || !isset($params["commission_arr"][0]["scale_fee"])) {
            return $this->response("101", "请求参数错误");
        }
 /*       $params = array(
            "submit_agent_id" => 1,//申请经纪人id
            "report_id"       => 1,//报备id
            "order_id"        => 1, //关联order表id
            "order_no"        => 1, //订单no

            "trade_type" => 1, //成交类型 10出租 20 增佣 30 代理 40 好处费
            "price"      => 1, //成交价格 存分
            "commission" => 1, //佣金 存分

            //`role` '分佣方 1盘方  2客方 3 反签 4独家  5合作方',
            //`agent_id`'分佣经纪人id',
            //`scale`'分佣比例 如 5表示百分之5',
            // `scale_fee` '应分佣金 存分 ',

            "commission_arr" => [ [ "role" => 10, "agent_id" => 10, "scale" => 10, "scale_fee" => 1222 ],
                [ "role" => 10, "agent_id" => 10, "scale" => 10, "scale_fee" => 1222 ] ],
        );*/

        $is_ok = $this->service_->addBargain($params["submit_agent_id"], $params["report_id"], $params["order_id"], $params["order_no"],
            $params["trade_type"], $params["price"], $params["commission"], $params["commission_arr"]);

        if ($is_ok > 0) {
            return $this->response("200", "request success", []);
        }
        return $this->response("101", "request faild");
    }

}