<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
use think\Route;

Route::rule('/','index/login/login');

Route::group('app', [
    'index' => [ 'app/index/index', [ 'method' => 'get' ] ],
    'agent_detail' => [ 'app/index/agent_detail', [ 'method' => 'get' ] ],
    'more_pingjia' => [ 'app/index/more_pingjia', [ 'method' => 'get' ] ],
    'more_chengjiao' => [ 'app/index/more_chengjiao', [ 'method' => 'get' ] ],
    'share_detail' => [ 'app/index/share_detail', [ 'method' => 'get' ] ],
    'share_register' => [ 'app/index/share_register', [ 'method' => 'get' ] ],
    'agreement' => [ 'app/index/agreement', [ 'method' => 'get' ] ],
    'agreement_app' => [ 'app/index/agreement_app', [ 'method' => 'get' ] ],
     'download' => [ 'app/index/download', [ 'method' => 'get' ] ],
    'getShopDetails' => [ 'app/index/getShopDetail', [ 'method' => 'get | post' ] ],
    'getVersionNo' => [ 'app/index/getVersionNo', [ 'method' => 'get | post' ] ],
]);


Route::group('index', [
    'member' => [ 'index/member.index/member', [ 'method' => 'get' ] ],
    'preview_list' => [ 'index/member.index/preview_list', [ 'method' => 'get' ] ],
    'consumer_list' => [ 'index/member.index/consumer_list', [ 'method' => 'get' ] ],
    'diagram_list' => [ 'index/member.index/diagram_list', [ 'method' => 'get' ] ],
    'entrust_list' => [ 'index/member.index/entrust_list', [ 'method' => 'get' ] ],

    //banner模块
    'banner' => [ 'index/banner/index', [ 'method' => 'get' ] ],
    'advertising' => [ 'index/banner/advertising', [ 'method' => 'get' ] ],
    'bannerList' => [ 'index/banner/getBannerList', [ 'method' => 'post' ] ],
    'getPopList' => [ 'index/banner/getPopList', [ 'method' => 'post' ] ],
    'addOrSave' => [ 'index/banner/addOrSave', [ 'method' => 'post' ] ],
    'upIsShow' => [ 'index/banner/upIsShow', [ 'method' => 'post' ] ],

    //user列表
    'usersList'  => ['index/member/getUserList',['method'=>'get']],
    'users_list' => ['index/member/index'],
    'user_add'   => ['index/member/user_add',['method'=>'post']],
    'del_user'   => ['index/member/delUser',['method'=>'post']],

    //transfer转铺列表
    'transfer_list' => ['index/transfer/index', ['method' => 'get']],
    'get_transfer'  => ['index/transfer/getlist', ['method' => 'get']],
    'putAway' => ['index/transfer/putAway', ['method'=>'post']],   //上下架转租商铺
    'addFollow' => ['index/transfer/addFollow',['method'=>'post']],  //添加跟进
    'followList' => ['index/transfer/followList',['method'=>'get']],  //跟进记录

    //login
    'login' => ['index/login/login',['method'=>'get']],
    'loginVerify' => ['index/login/loginVerify',['method'=>'post|get']],
    'logout' =>['index/login/logout',['method'=>'get']],  //退出
    //watchshop 预约看铺
    'watch_shop' => ['index/WatchShop/index',['method'=>'get']],
    'get_watch'  => ['index/WatchShop/getList',['method'=>'get']],
    'add_applies'  => ['index/WatchShop/addApplies',['method'=>'post']],

    //查询经纪人
    'getBroker'  => ['index/broker/getBroker',['method'=>'get']],
    'getBroker_new'  => ['index/broker/getBroker_new',['method'=>'get']],
    'addHousesAgents' => ['index/broker/AddHousesAgents', ['method' => 'POST']], //新增楼盘与经纪人关系
    'delTohouses' => ['index/broker/delTohouses', ['method' => 'POST']], //解除经纪人和楼盘关系
    'getAgentsTohouses' => ['index/broker/getAgentsTohouses', ['method' => 'GET']], //获取经纪人和楼盘关系信息

    //版本管理
    'version'  => ['index/version/index',['method'=>'get']],
    'getVersionNo'  => ['index/version/getVersionNo',['method'=>'post']],
    'getVersionList'  => ['index/version/getVersionList',['method'=>'post']],
    'addVersion'  => ['index/version/addVersion',['method'=>'post']],

    //权限管理
    'classList'  => ['index/auth/classList',['method'=>'get']],             //分类列表
    'getAuth'     => ['index/auth/getAuth', ['method' => 'get']],           //角色列表
    'getAuth2'     => ['index/auth/getAuth2', ['method' => 'get']],           //角色列表2无分页
    'roleedit'     => ['index/auth/roleEdit', ['method' => 'get']],         //--编辑角色页面
    'access'     => ['index/auth/access', ['method' => 'get']],             //--权限分配角色页面
    'updateAccess'    => ['index/auth/updateAccess', ['method' => 'post']], //--编辑角色权限【接口】
    'addAuth'     => ['index/auth/addAuth', ['method' => 'get|post']],          //--添加角色【接口】
    'accessLook'=>['index/auth/accessLook', ['method' => 'get|post']],          //--查看编辑角色权限【接口】
    'setStatus'=>['index/auth/setStatus', ['method' => 'post']],            //--设置角色的状态【接口】

    'accessUser'     => ['index/auth/accessUser', ['method' => 'get']],     //成员授权
    'authRuleIndex'=>['index/auth/authRuleIndex', ['method' => 'get']],     //权限列表界面
    'authRuleList'=>['index/auth/authRuleList', ['method' => 'get']],       //--规则列表
    'authRuleBox'=>['index/auth/authRuleBox', ['method' => 'get']],         //--编辑规则
    'updateAuthRule'=>['index/auth/updateAuthRule', ['method' => 'get|post']],  //--编辑规则接口
    'authClass'=>['index/auth/authClass', ['method' => 'get']],             //--规则分类列表

    'agent'=>['index/agent/agent', ['method' => 'get']],                        //列表
    'saveAgentIndex'=>['index/agent/saveAgentIndex', ['method' => 'get']],      //列表
    'AgentList'=>['index/agent/AgentList', ['method' => 'get']],                //列表
    'saveAgent'=>['index/agent/saveAgent', ['method' => 'get|post']],                //列表
    'updateStatus'=>['index/agent/updateStatus', ['method' => 'get']],            //列表
    'updateRole'=>['index/agent/updateRole', ['method' => 'post']],               //经纪人角色修改接口


    //商圈
    'BusinessDistrict' => ['index/BusinessDistrict/index', ['method' => 'get']], //商圈列表
    'editBusinessDistrict' => ['index/BusinessDistrict/edit', ['method' => 'get | post']], //编辑商圈
    'delBusinessDistrict' => ['index/BusinessDistrict/del', ['method' => 'post']], //删除商圈列表

    //商铺
    'BusinessList' => ['index/BusinessDistrict/getBusiness', ['method' => 'get']], //获取商铺列表数据
    'houseList' => ['index/Houses/index', ['method' => 'get']], //商铺列表
    'houseEdit' => ['index/Houses/edit', ['method' => 'get|post']], //编辑商铺
    'houseDel' => ['index/Houses/del', ['method' => 'post']], //删除商铺
    'regions'  => ['index/BusinessDistrict/regions', ['method' => 'get']], //获取省市区数据
    'getHouseList' => ['index/houses/getHouseList', ['method' => 'get']], //楼盘列表
    'carefullyChosen' => ['index/houses/carefullyChosen', ['method' => 'post']], //设置精选楼盘
    'editExclusive' => ['index/houses/editExclusive', ['method' => 'post']], //添加和编辑楼盘独家
    'getExclusive' => ['index/houses/getExclusive', ['method' => 'get']], //获取楼盘独家
    'getRecords' => ['index/houses/getRecords',['method'=>'get']],  //操作记录
]);


Route::group('api', [
    //get
    'sendSms/:phone' => [ 'api/member/sendSms', [ 'method' => 'get' ] ],   //发送短信
    'sendSms' => [ 'api/member/sendSms', [ 'method' => 'get' ] ],   //发送短信
    'check_code' => [ 'api/member/check_code', [ 'method' => 'get' ] ],   //检测短信
    'index' => [ 'api/member/index', [ 'method' => 'get' ] ],


    //get broker
    'getBroker' => [ 'api/broker/index', [ 'method' => 'get' ] ],        //获取当前商铺或街铺的经纪人评论信息列表
    'commentAndDeal' => [ 'api/broker/commentAndDeal', [ 'method' => 'get' ] ],        //获取当前经纪人的评价和交易列表
    'brokerDetail' => [ 'api/broker/brokerDetail', [ 'method' => 'get' ] ],   //经纪人详情
    //post broker
    'appraiser' => [ 'api/broker/appraiser', [ 'method' => 'post' ] ],    //评价经纪人

    //get member
    'logout' => [ 'api/member/logout', [ 'method' => 'get' ] ],
    'inviteList/:id' => [ 'api/member/inviteList', [ 'method' => 'get' ] ], //邀请记录
    'inviteList' => [ 'api/member/inviteList', [ 'method' => 'get' ] ], //邀请记录
    'qrCode' => [ 'api/member/qrCode', [ 'method' => 'get' ] ], //邀请二维码
    'getUserInfo' => ['api/member/getUserInfo',['method'=>'get']],  //通过AuthToken获取用户信息编辑用


    //post member
    'login' => [ 'api/member/login', [ 'method' => 'post' ] ],           //c端登陆
    'register' => [ 'api/member/register', [ 'method' => 'post' ] ],  //注册|邀请注册|编辑
    'uploadHeadImg' =>['api/member/uploadHeadImg',['method'=>'post']],  //头像上传

    // shop
    'shopList' => [ 'api/shop/getShopList', [ 'method' => 'post' ] ],
    'filtrateCondition' => [ 'api/shop/filtrateCondition', [ 'method' => 'get | post' ] ],
    'shopDetail' => [ 'api/shop/getShopDetail', [ 'method' => 'get' ] ],

    //get banner
    'bannerList' => [ 'api/banner/getBannerList', [ 'method' => 'get' ] ],

    //get index
    'averagePriceAndTurnover' => [ 'api/index/averagePriceAndTurnover', [ 'method' => 'get' ] ],


    //post AppointmentTime
    'getAppointmentSeeShopList' => [ 'api/appointmentTime/getAppointmentSeeShopList', [ 'method' => 'post' ] ],
    'addAppointmentSeeShop' => [ 'api/appointmentTime/addAppointmentSeeShop', [ 'method' => 'post|get' ] ],


    //tradeLog
    'getTradeList' => [ 'api/TradeLog/getTradeList', [ 'method' => 'post|get' ] ],

    //AttentionShop
    'addOrUpdateAttention' => [ 'api/AttentionShop/addOrUpdateAttention', [ 'method' => 'post|get' ] ],
    'attentionList' => [ 'api/AttentionShop/attentionList', [ 'method' => 'post | get' ] ],



    'addSublet' => [ 'api/Sublet/addSublet', [ 'method' => 'post|get' ] ],


    //Version
    'getVersionNo' => [ 'api/Version/getVersionNo', [ 'method' => 'post' ] ],


]);

Route::group('task',[
    'exclusiveExpirationTime' =>  [ 'task/exclusive/exclusiveExpirationTime', [ 'method' => 'get' ]]  //独家过期时间
]);

Route::group('broker',[
    'report' =>  [ 'api_broker/FollowUp/report', [ 'method' => 'get|post' ]]  //报备
]);

//Route::miss('api/index/miss');//处理错误的url