<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2017/12/22
 * Time: 14:44
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\AAgents;
use app\model\Agents;
use app\model\GHousesToAgents;

class Broker extends Basic
{

    /**
     * 获取经纪人列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getBroker() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['code'] = '';
        $data['msg']  = '';

        $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
        $pageSize = empty($this->params['pageSize']) ? 10 : $this->params['pageSize'];
        $where    = '';
        if ($this->params['phone']) {
            $where = 'phone like "'.$this->params['phone'].'%" or realname like "'.$this->params['phone'].'%"';
        }

        if ($where) {
            $agent  = new Agents();
            $field  = 'id,father_id,realname,phone';
            $data['data'] = $agent->getAgents($pageNo, $pageSize, '', $field, $where);
        } else {
            $data['msg'] = '没有该楼盘信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 获取经纪人列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getBroker_new() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';

        $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
        $pageSize = empty($this->params['pageSize']) ? 10 : $this->params['pageSize'];
        $where    = '';
        if ($this->params['phone']) {
            $where = 'phone like "'.$this->params['phone'].'%" or name like "'.$this->params['phone'].'%"';
        }

        if ($where) {
            $agent  = new AAgents();
            $field  = 'id,name,phone';
            $data['data'] = $agent->getList($pageNo, $pageSize, '', $field, $where);
        } else {
            $data['msg'] = '没有经纪人信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 添加经纪人与楼盘关系
     *
     * @return \think\Response
     * @throws \Exception
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function AddHousesAgents() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';

        if ($this->params['houses_id']) {
            $hg = new GHousesToAgents();
            switch ($this->params['type']) {
                case 1:
                    $res = $hg->addAgents($this->params['agents_id'], $this->params['houses_id'], $this->params['type']);break;
                case 2:
                    $res = $hg->addAgents($this->params['agents_id'], $this->params['houses_id'], $this->params['type']);break;
                default :
                    $data['status'] = 101;
                    $data['msg'] = 'type is null';
            }

            if (!count($res) > 0) {
                $data['status'] = 200;
                $data['msg']    = 'Data already exists';
                $data['data']   = $res;
            }

        } else {
            $data['status'] = 101;
            $data['msg'] = 'houses_id is null';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 解除经纪人和楼盘关系
     *
     * @return \think\Response
     */
    public function delTohouses() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';

        if ($this->params['id'] && $this->params['houses_id']) {
            $hg = new GHousesToAgents();
            $hg->del($this->params['id'], $this->params['houses_id']);
        } else {
            $data['status'] = 101;
            $data['msg']    = 'id or houses_id is null';
        }
        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 获取经纪人和楼盘关系信息
     *
     * @return \think\Response
     */
    public function getAgentsTohouses() {
        $data['status'] = 200;
        $data['data'] = '';
        $data['msg']  = '';

        if ($this->params['houses_id']) {
            $pageNo   = empty($this->params['pageNo']) ? 1 : $this->params['pageNo'];
            $pageSize = empty($this->params['pageSize']) ? 10 : $this->params['pageSize'];
            $hg = new GHousesToAgents();
            $fields = 'b.id,b.name,b.phone';
            $where['a.is_del'] = ['=',0];
            $where['b.status'] = ['=',0];
            $where['a.type']   = $this->params['type'];
            $where['a.houses_id'] = $this->params['houses_id'];
            $data['data'] = $hg->getAgentsHousesList($pageNo, $pageSize, 'id DESC', $fields, $where);
        } else {
            $data['status'] = 101;
            $data['msg']    = 'houses_id is null';
        }
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
}