<?php

namespace app\api_broker\service;

use app\model\OrderModel;
use app\model\reportModel;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2018/1/26
 * Time : 16:41
 * Intro:
 */
class ReportService
{

    private $reportModel;
    private $orderModel;

    function __construct()
    {
        $this->reportModel = new ReportModel();
        $this->orderModel    = new OrderModel();
    }

    /**
     * 生成报备和保存订单
     * @param $agent_id
     * @param $store_id
     * @param $user_id
     * @param $house_ids
     * @param $vehicle
     * @param $intro
     * @param $predict_see_time
     * @return int
     */
    public function verifyReport($agent_id, $store_id, $user_id, $house_ids, $vehicle, $intro, $predict_see_time)
    {

        $id = $this->reportBin($agent_id, $store_id, $user_id, $vehicle, $intro, $predict_see_time);

        if ($id > 0) {
            $house_arr = explode(",", $house_ids);
            $order_arr = [];
            foreach ($house_arr as $k => $v) {
                //todo 批量插入到数据库
                $order_no = $this->createOrderNumber();
                array_push($order_arr, $this->orderBin($order_no, $id, $v));
            }
            //todo 保存order表
            return $this->orderModel->insertOrderByAll($order_arr);

        }

    }


    /**
     * 订单号
     * @return string
     */
    private function createOrderNumber()
    {
        return time() . mt_rand(100000, 999999);
    }

    /**
     * 报备主表
     * @param $report_agent_id
     * @param $report_store_id
     * @param $user_id
     * @param $vehicle
     * @param $intro
     * @param $predict_see_time
     * @return array
     */
    private function reportBin($report_agent_id, $report_store_id, $user_id, $vehicle, $intro, $predict_see_time)
    {
        $param["report_agent_id"]  = $report_agent_id;
        $param["report_store_id"]  = $report_store_id;
        $param["user_id"]          = $user_id;
        $param["vehicle"]          = $vehicle;
        $param["status"]           = 0;
        $param["intro"]            = $intro;
        $param["predict_see_time"] = date("Y-m-d H:i:s", $predict_see_time);
        $param["create_time"]      = date("Y-m-d H:i:s", time());
        $param["update_time"]      = date("Y-m-d H:i:s", time());
        return $this->reportModel->addReport($param);
    }

    /**
     * 订单子表
     * @param $order_no
     * @param $f_id
     * @param $house_id
     * @return mixed
     */
    private function orderBin($order_no, $f_id, $house_id)
    {
        $param["order_no"] = $order_no;
        $param["f_id"]     = $f_id;
        $param["house_id"] = $house_id;
        return $param;

    }
}