$(function() {
	$(document.body).show();
	var _doc = $(document);
	var _appToken = getUrlParam('token');
	
	if(_appToken !== null) {
		_doc.on('click', '.ps-back', function(e) {
			e.preventDefault();
			e.stopPropagation();
			Compatible({
				paraIos: {
					'route': "aabb",
					'url': 'back'
				},
				fnAndroid: function() {
					window.android.onBackPressed();
				},
				fn: function() {
					console.warn('error');
				}
			});
		});
		h5Page(_appToken, function(data) {
			loadMain();
		});
	} else {
		loadMain();
	};
	
	function loadMain() {
		var _token = localStorage.getItem('token');
		$.ajax({
			type: 'get',
			url: ServerHost + '/api/brokerDetail',
			timeout: 30000,
			dataType: 'json',
			data: {
				'AuthToken': _token
			},
			beforeSend: function() {},
			success: function(data) {
				if(typeof data === 'object') {
					if(data['code'] == 200) {
						$('#name_jingjiren').html(data['data']['realname']);
						$('#time_ruzhi').html(data['data']['created']);
						$('#name_store').html(data['data']['sub_shopname']);
						$('.portrait-area>img').attr('src', data['data']['head_portrait']);
						$('#pingjia_fen').html(parseInt(data['data']['evaluate_grade']));
						$('.pingfen-area-large').html(dealStar(parseInt(data['data']['evaluate_grade'])));
						$('#pingjia_shu').html(Number(data['data']['evaluate_num']) > 99 ? '99+' : Number(data['data']['evaluate_num']));
						$('#chengjiao_lishi').html(data['data']['JournalAccounts']);
						$('#daikan_30').html(data['data']['watch_shop']);
					} else {
						layerTipsX(data['msg']);
					};
				} else {
					layerTipsX('数据错误');
				};
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				layerTipsX('error');
			},
			complete: function(xhr, textStatus) {
				if(textStatus === 'timeout') {
					layerTipsX('请求超时');
				};
			}
		});

		function dealStar(_fen) {
			var _htmlTemp = '';
			for(var i = 1; i < 6; i++) {
				if(i < _fen / 2 + 0.5) {
					_htmlTemp += '<small class="small-active"></small>';
				} else if(i == _fen / 2 + 0.5) {
					_htmlTemp += '<small class="small-active-guodu"></small>';
				} else {
					_htmlTemp += '<small></small>';
				}
			};
			return _htmlTemp;
		};

		function dealStarText(_fen) {
			if(_fen >= 8) {
				return '非常推荐';
			} else if(_fen >= 6) {
				return '很好';
			} else if(_fen >= 4) {
				return '一般';
			} else if(_fen >= 4) {
				return '很差';
			} else {
				return '非常差';
			};
		};

		function dealScale(obj) {
			if(obj['shangpu_type'] == '0') {
				return Number(obj['room_area']) + '-' + Number(obj['room_area2']) + 'm²';
			} else {
				return Number(obj['room_area']) + 'm²';
			};
		};

		$.ajax({
			type: 'get',
			url: ServerHost + '/api/commentAndDeal',
			timeout: 30000,
			dataType: 'json',
			data: {
				'agent_id': 9,
				'type': 0,
				'pageNo': 1,
				'pageSize': 3
			},
			beforeSend: function() {},
			success: function(data) {
				if(typeof data === 'object') {
					if(data['code'] == 200) {
						//评价列表
						if(data['data']['evaluate'] && data['data']['evaluate'].length > 0) {
							var _html = "";
							$.each(data['data']['evaluate'], function(i, item) {
								if(i < 2) {
									_html += '<li><div class="li-top-area oh"><figure class="li-top-area-left fl"><div class="oh fl"><img src="{7}" class="fl"></div><figcaption class="oh fl"><p>{0}</p><div class="oh"><div class="pingfen-area fl">{1}</div><p class="fl">{2}</p></div></figcaption></figure><div class="li-top-area-right fr">{3}</div></div><div class="li-bottom-area"><h3>{4}在{5}看房</h3><p>{6}</p></div></li>'.stringFormatObj({
										'0': item['user_nick'],
										'1': dealStar(item['evaluate_grade']),
										'2': dealStarText(item['evaluate_grade']),
										'3': '2017-12-17',
										'4': '2017-03',
										'5': '长宁路',
										'6': item['evaluate_content'],
										'7': item['user_pic']
									});
								};
							});
							$('.pingjia-list-area>ul').html(_html);
							data['data']['evaluate'].length > 2 && $('.pingjia-list-area .see-all-area').show().find('a').attr('href', 'more_pingjia?id=' + 9);
						} else {
							$('.pingjia-list-area .zanwu_data').show();
						};

						//成交列表
						if(data['data']['journalAccounts'] && data['data']['journalAccounts'].length > 0) {
							var _html2 = "";
							$.each(data['data']['journalAccounts'], function(i, item) {
								if(i < 2) {
									_html2 += '<li class="oh"><div class="fl oh"><img src="{5}"></div><div class="fl"><h3 class="shangpu-name ellipsis">{0}</h3><p class="qianyue-time">签约时间：{1}</p><p class="mianji-scale">{2}</p><p class="zuji-price">租金均价：<span>{3}</span>元/月</p><p class="sp-text oh">{4}</p></div></li>'.stringFormatObj({
										'0': item['title'],
										'1': '2017-12-12',
										'2': dealScale(item),
										'3': item['price'],
										'4': '<span>小面积</span><span>随时看铺</span><span>沿街旺铺</span>',
										'5': item['img']
									});
								};
							});
							$('.chengjiao-list-area>ul').html(_html2);
							data['data']['evaluate'].length > 2 && $('.chengjiao-list-area .see-all-area').show().find('a').attr('href', 'more_chengjiao?id=' + 9);
						} else {
							$('.chengjiao-list-area .zanwu_data').show();
						};
					} else {
						layerTipsX(data['msg']);
					};
				} else {
					layerTipsX('数据错误');
				};
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				layerTipsX('error');
			},
			complete: function(xhr, textStatus) {
				if(textStatus === 'timeout') {
					layerTipsX('请求超时');
				};
			}
		});
	};
});