<?php

namespace app\model;

use think\Db;
use think\Model;

class Users extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_users';

    public function selectUser($userId, $fields = 'id,user_phone')
    {
        $param["status"] = array( "eq", 0 );
        return $this->field($fields)
            ->where($param)
            ->find($userId);
    }
    
    /**
     * 查询用户和经纪人
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $fields
     * @param type $params
     * @return type
     */
    public function getUserAgent($pageNo = 1, $pageSize = 15, $order_ = 'a.id desc', $fields = '*', $params = '') {
        $result = $this->field($fields)->alias('a')
                ->join('agents b','a.referrer_id = b.id', 'left')
                ->where($params)
                ->order($order_)
                ->limit($pageSize)
                ->page($pageNo)
                ->select();

        return $result; 
    }

    /**
     * 获取查询用户和经纪人总数
     *
     * @param $params
     * @return mixed
     */
    public function getUserAgentTotal($params) {
        $result = $this->alias('a')
            ->join('agents b','a.referrer_id = b.id', 'left')
            ->where($params)
            ->count();

        return $result;
    }
 }
