<?php

namespace app\model;

use think\Model;
use think\helper\Time;
use think\Db;
class JournalAccounts extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'Journalaccounts';
    protected $db;

    function __construct()
    {
        $this->db = Db($this->table);
    }

    /**
     * 获取月均价
     * @return float
     */
    function getTurnover()
    {
        $timeArr = Time::lastWeek();
        $signStartTime = date("Y-m-d H:i:s", $timeArr[0]);
        $signEndTime = date("Y-m-d H:i:s", $timeArr[1]);
        $where_['singntime'] = array( "between", array( $signStartTime, $signEndTime ) );
        return $this->db
            ->where($where_)
            ->count("id");
    }

    /**
     * 成交记录列表
     *
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $agent_id
     * @return type
     */
    public function getJournalHouseInfo($pageNo = 1, $pageSize = 15, $order_ = 'j.id desc', $field, $params, $agent_id = '') {

        if ($agent_id) {
            $result = $this->db->field($field)->alias('j')
                    ->join('applies a','j.apply_id = a.id','LEFT')
                    ->where('a.agent_id', $agent_id)
                    ->group('j.apply_id')
                    ->limit($pageSize)
                    ->order($order_)
                    ->page($pageNo)
                    ->select();
        } else {
            $result = $this->field($field)->alias('j')
                    ->join('applies a', 'j.apply_id = a.id','left')
                    ->where('a.agent_id', $agent_id)
                    ->group('j.apply_id')                    
                    ->limit($pageSize)
                    ->order($order_)
                    ->page($pageNo)
                    ->select();
        }

        $fields_houinfo = 'id,title,rent_type,price,room_area,room_area2,shangpu_tags,shangpu_type';
        //查找商铺或街铺的名字和图片
        foreach ($result as $key => $value) {
            $data[$key] = Db::table('houseinfos')
                ->field($fields_houinfo)->where('id',$value['house_id'])->find();
            $data[$key]['singntime'] = date('Y-m-d',strtotime($value['singntime']));
            $data[$key]['shangpu_tags'] = explode(',',$data[$key]['shangpu_tags']);

            $img = Db::table('houseimgs')->field('imagename')
                    ->where('house_id', $value['house_id'])->where('imgtype',1)->find();

            if ($img['imagename']) {
                $data[$key]['img'] = $_SERVER['SERVER_NAME'].'/houseImg/'.$img['imagename'];
            } else {
                $data[$key]['img'] = $_SERVER['SERVER_NAME'].'/resource/image/pzz_.jpg';
            }

        }

        return $data;
    }
    /**
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $param
     * @return mixed
     */
    public function getJournalAccountsList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $param)
    {
        $params["b.phpone"] = $param["phone"];
        return  $this->db
            ->field($field)
            ->alias("a")
            ->join('applies b','a.apply_id = b.id' ,'LEFT')
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }
    
    /**
     * 查询当前经纪人的成交记录
     * 
     * @param type $param
     * @return type
     */
    public function getJournalHouseInfoId($fields = '', $agent_id) {
        if ($agent_id) {
            $result = $this->field($fields)->alias('j')
                    ->join('applies a', 'j.apply_id = a.id')
                    ->where('a.agent_id', $agent_id)
                    ->where('j.transaction_status = 3')
                    ->find();
        } else {
            $result = $this->field($fields)->alias('j')
                    ->join('applies a', 'j.apply_id = a.id')
                    ->where('a.agent_id', $agent_id)
                    ->where('j.transaction_status = 3')
                    ->find();
        }
        return $result;
    }

}
