<?php

namespace app\index\controller;
use app\index\extend\Basic;
use app\model\Users;
use think\Response;

/**
 * Description of Member
 *
 * @author : fuju
 * @date   :   2017-12-15 17:45:12
 * @internal :  用户
 */
class Member extends Basic{
    
    public function index() {
        return view('member/users_list');
    }
    
    public function getUserList(Response $request) {
        $data['status'] = 200;
        $data['msg']    = '';

        $pageNo   = empty($_GET['pageNo']) ? 1 : $_GET['pageNo'];
        $pageSize = empty($_GET['pageSize']) ? 15 : $_GET['pageSize'];

        $where['status'] = 0;

        if ($_GET['name']) {
            $where['a.user_nick'] = $_GET['name'];
        }

        if ($_GET['phone']) {
            $where['a.user_phone'] = $_GET['phone'];
        }

        if ($_GET['invite']) {
            $where['b.phone'] = $_GET['invite'];
        }

        $user = new Users();

        $fields = 'a.id,a.user_nick,a.user_phone,a.user_pic,a.create_time,b.realname';
        $data['list'] = $user->getUserAgent($pageNo, $pageSize, '', $fields, $where);
        $data['total'] = $user->getUserAgentTotal($where);
        $data['pageNo'] = $pageNo;
        $data['pageSize'] = $pageSize;
        return $this->response($data['status'], $data['msg'], $data);
    }
}
