<?php
namespace app\app\controller;

use app\model\HouseImgs;
use app\model\HouseInfos;
use think\Controller;
use think\Response;

class Index
{

    protected $db;
    protected $dbImg;
    public function __construct()
    {

        $this->db = new HouseInfos();
        $this->dbImg = new HouseImgs();
    }

    public function index()
    {
      return view('index/index'); 
    }
    public function share_detail()
    {
      return view('index/share_detail');
    }
    public function agent_detail()
    {
      return view('index/agent_detail');
    }
    public function more_pingjia()
    {
      return view('index/more_pingjia');
    }
    public function more_chengjiao()
    {
      return view('index/more_chengjiao');
    }
    /**
     * 楼盘详情
     * @return \think\Response
     */
    public function getShopDetail()
    {
        $id = $_POST["id"];
        $field = "id,management_fee,title,address,city,room_area,room_area2,business_area,disc,disccircles,sales,slotting_fee,transfer_fee,
        yetai,room_area2,shangpu_type,is_test,sellingpoint,singn_rule,business_date,start_business_date,opentime,has_gas,traffic,
        room_num_left,room_num_total,shangpu_tags,carefully_chosen,price,dish,file_path";

        $conditions = [];
        if (empty($id)) {
            return $this->response("101", "详情id不能为空");
        }

        $conditions['id'] = array( "eq", $id );
        $conditions['show_all'] = array( 'eq', 0 ); //只显示公开楼盘

        $result = $this->db->getHouseDetail($field, $conditions);

        $result["api_path"] = IMG_PATH;
        $param["house_id"] = $id;
        $result["images"] = $this->dbImg->getHouseImages($param, 15);
        if ($result['room_num_left'] == 0) {
            return $this->response("101", '此楼盘已下架');
        }
        return $this->response("200", 'request success', $result);
    }


    /**
     * 输出返回数据
     * @param string $msg 提示消息内容
     * @param string $code 业务状态码
     * @param mixed $data 要返回的数据
     * @param string $type 返回类型 JSON XML
     * @return Response
     */
    public function response($code = 'SUCCESS', $msg, $data = [], $type = 'json')
    {
        $result = [ 'code' => $code, 'msg' => $msg, 'data' => $data, 'type' => strtolower($type) ];
        return Response::create($result, $type);
    }
}
