<?php

namespace app\api\controller;

use app\api\extend\Basic;
use app\model\AttentionModel;
use think\Request;
use app\model\HouseImgs;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/13
 * Time : 10:20
 * Intro: 我的关注楼盘列表
 */
class AttentionShop extends Basic
{

    protected $attentionModel;
    protected $dbImg;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->attentionModel = new AttentionModel();
        $this->dbImg = new HouseImgs();
    }

    /**
     * 新增或者取消我的关注
     * @return \think\Response
     */
    public function addOrUpdateAttention()
    {
        $params = $this->params;
     /*      $params = array(
            //   "id" => 2,
               "user_id" => 3,
               "house_id" => 2,
              // "is_del" => 0
           );*/
        $msg = isset($params['id']) ? "修改" : "新增";
        $result = $this->attentionModel->addOrUpdateAttentionShop($params);
        if ($result['code'] == 200) {
            return $this->response("200", $msg . "成功", $result["msg"]);
        } else {
            return $this->response("101", $msg . $result["msg"]);
        }
    }


    /**
     * 我的关注商铺列表
     * @return \think\Response
     */
    public function attentionList()
    {
        $params = $this->params;
    /*    $params = array(
            "user_id" => 1,
            "pageNo" => 1,
            "pageSize" => 15,
        );*/
        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];


        $order_ = 'a.create_time desc';

        $field = "a.id,b.title,b.area,b.room_area2,b.price,b.shangpu_tags";

        if (!isset($params["user_id"])) {
            return $this->response("101", "用户id不能为空");
        }
        $params["is_del"] = 0;  //关注中的商铺

        $result = $this->attentionModel->myAttentionList($pageNo, $pageSize, $order_, $field, $params);
        if (count($result) <= 0) {
            return $this->response("200", "请求数据为空");
        }
        foreach ($result as $key => $val) {
            $result[$key]["api_path"] = IMG_PATH;
            $imgParam["house_id"] = $val["house_id"];
            $imgParam["imgtype"] = 1; //默认主图
            $result[$key]["images"] = $this->dbImg->getHouseImages($imgParam, 1);
        }
        return $this->response("200", "request success", $result);
    }



}