<?php

namespace app\api\controller;

use app\api\extend\Basic;
use app\model\AppointWatchShop;
use app\model\HouseInfos;
use think\helper\Time;
use app\model\HouseImgs;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/8
 * Time : 17:18
 * Intro: 预约看铺模块
 */
class AppointmentTime extends Basic
{

    protected $db;
    protected $appointmentTimeModel;
    protected $houseInfoModel;
    protected $dbImg;

    function __construct($request = null)
    {
        parent::__construct($request);
        $this->appointmentTimeModel = new AppointWatchShop();
        $this->houseInfoModel = new HouseInfos();
        $this->dbImg = new HouseImgs();
    }

    /**
     * 增加预约楼盘信息
     * @return \think\Response
     */
    public function addAppointmentSeeShop()
    {
        $params = $this->params;
        /*         $params = array(
                            "user_id" => 1,
                            "house_id" => 1,
                            "house_title" => "楼盘1",
                            "appellation" => "张三",
                            "phone" => "13817616312",
                            "expect_time" => time() + 1000,
                            "other_require" => "没有其他要求"
                        );*/

        //todo 验证楼盘信息
        if (isset($params["house_id"]) && isset($params["house_title"])) {
            $where_["id"] = $params["house_id"];
            $houseInfo = $this->houseInfoModel->getHouseDetail("id", $where_);
            if (count($houseInfo) <= 0) {
                return $this->response("101", "楼盘ID或楼盘名错误");
            }
        } else {
            return $this->response("101", "楼盘信息不能为空");
        }
        //todo 参数校验
        if (!isset($params["phone"]) || !preg_match('/1[345678]\d{9}/', $params["phone"])) {
            return $this->response("101", "手机号为空或手机号无效");
        }

        if (!isset($params["expect_time"]) || $params['expect_time'] <= time()) {
            return $this->response("101", "预约时间为空，或者小于当前时间");
        }
        $addPrams =array(
            'expect_time' => date("Y-m-d H:i:s", strtotime($params["expect_time"]/1000)),
            'phone' => $params["phone"],
            'house_title' => $params["house_title"],
            'house_id' => $params["house_id"],
            'appellation' => $params["appellation"],
            'user_id' => $params["user_id"],
            'create_time'=>date("Y-m-d H:i:s", time()),
            'update_time' =>date("Y-m-d H:i:s", time())
        );
        $result = $this->appointmentTimeModel->insertAppointWatchShop($addPrams);
        if ($result["code"] == 200) {
            return $this->response("200", "数据保存成功", $result["msg"]);
        }else{
            return $this->response("101", "数据保存失败");
        }



    }

    /**查询预约看铺列表
     *
     * @return \think\Response
     */
    public function getAppointmentSeeShopList()
    {
        /*   $params = array(
           "status" => 2, //看铺状态 0待经纪人确认（确认后存agents_id） 1:待看 2：已看' 如果是待看 0,1 已看是2
           "user_id" => "1",//对应u_users表
           "pageNo" => "1",
           "pageSize" => 15
       );*/

        $params = $this->params;


        $field = "id,user_id,agents_id,house_id,house_title,appellation,phone,expect_time,other_require,status,
                   is_cancel,is_evaluate,create_time";


        $where_ = [];
        if (!isset($params["status"])) {
            return $this->response("101", "请求状态不能为空");
        }
        if (!isset($params["user_id"])) {
            return $this->response("101", "请求用户不能为空");
        }

        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $where_["status"] = array( "eq", $params["status"] );
        $where_["user_id"] = array( "eq", $params["user_id"] );

        $result = $this->appointmentTimeModel->getAppointWatchShopList($pageNo, $pageSize, "id desc", $field, $where_);
        //获取图片信息
        foreach ($result as $key => $val) {
            $result[$key]["api_path"] = IMG_PATH;
            $param["house_id"] = $val["house_id"];
            $param["imgtype"] = 1; //默认主图
            $result[$key]["images"] = $this->dbImg->getHouseImages($param, 1);
        }


        if (count($result) > 0) {
            return $this->response("200", "request success", $result);
        } else {
            return $this->response("200", "此条件没有找到数据");
        }
    }


}