<?php

namespace app\index\controller;
use app\index\extend\Basic;
use app\model\Users;
use think\Request;


/**
 * Description of Member
 *
 * @author : fuju
 * @date   :   2017-12-15 17:45:12
 * @internal :  用户
 */
class Member extends Basic{
    protected $user;
    public function __construct(Request $request = null)
    {
        parent::__construct($request);
        $this->user = new Users();
    }

    public function index() {
        return view('member/users_list');
    }

    /**
     * 用户列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getUserList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $where['status'] = 0;

        if (!empty($params['name'])) {
            $where['a.user_nick'] = ['like', $params['name'].'%'];
        }

        if (!empty($params['phone'])) {
            $where['user_phone'] = ['like', $params['phone'].'%'];
        }

        if (!empty($params['invite'])) {
            $where['phone'] = $params['invite'];
        }

        if (!empty($params['id'])) {
            $where['a.id'] = $params['id'];
        }

        $fields = 'a.id,a.user_nick,a.user_phone,a.user_pic,a.create_time,a.user_pswd,a.referrer_id,a.referrer_source';
        $data['list'] = $this->user->getUserAgent($pageNo, $pageSize, '', $fields, $where);
        $data['total'] = $this->user->getUserAgentTotal($where);
        return $this->response($data['status'], $data['msg'], $data);
    }

    /**
     * 新增或编辑用户
     *
     * @return \think\Response
     * @throws \think\exception\DbException
     */
    public function user_add() {
        $params = $this->request->param();
        $status = 101;
        $msg    = '';
        $data   = '';

        if (empty($params['id'])) {
            $user_data = $this->user->get(['user_phone'=> $params['user_phone']]);
        } else {
            $user_data = $this->user->get($params['id']);
        }

        $date = date('Y-m-d H:i:s');

        if (!check_phone($params['user_phone'])) {
            return $this->response($status, '手机号错误');
        }

        if (empty($user_data) && $params['type'] == 'add') {
            $inser_data['user_nick']  = $params['realname'];
            $inser_data['user_phone'] = $params['user_phone'];
            $inser_data['user_pswd']  = md5(md5($params['pwd']).'+123');
            $inser_data['status']     = 0;
            $inser_data['create_time']  = $date;
            $inser_data['update_time']  = $date;

            $this->user->save($inser_data);
            if ($this->user->id) {
                $status = 200;
                $data   = ['id'=>$this->user->id];
                $msg    = '添加用户成功';
            } else {
                $msg = '新增用户失败';
            }
        } else {
            if (!empty($user_data) && $params['type'] == 'edit'){
                $user_data->user_nick  = $params['realname'] ? $params['realname'] : $user_data->user_nick;
                $user_data->user_phone = $params['user_phone'] ? $params['user_phone'] : $user_data->user_phone;
                $user_data->user_pswd  = $params['pwd'] != $user_data->user_pswd ? md5(md5($params['pwd']).'+123') : $user_data->user_pswd;
                $user_data->status     = $params['status'] ? $params['status'] : $user_data->status;
                $user_data->update_time  = $date;

                $user_data->save();

                if ($user_data->id) {
                    $status = 200;
                    $data   = ['id'=>$user_data->id];
                    $msg    = '编辑用户成功';
                } else {
                    $msg = '编辑用户失败';
                }
            } else {
                $msg = '该用户已存在';
                $status = 101;
            }
        }

        return $this->response($status, $msg, $data);
    }

    /**
     * 删除用户
     * @return \think\Response
     */
    public function delUser() {
        $data['data'] = '';
        $data['code'] = '';
        $data['msg']  = '';

        $id   = $this->request->param('id');
        $data = $this->user->delete_user($id);
        return $this->response($data['code'], $data['msg'], $data['data']);
    }
}
