<?php

/**
 * Created by fuju
 * User : hj
 * Date : 2017-12-7
 * Time : 15:15:42
 * Intro: 
 */

namespace app\api\validate;

use think\Validate;

class Users extends Validate {

    protected $rule = [
        'user_phone' => '/^1[34578]{1}\d{9}$/',
        'referrer_id'     => 'require|number',
        'referrer_source' => 'require|number',
        'code'            => 'require|number'
    ];
    protected $message = [
        'user_phone' => 'Phone member is error',
        'referrer_id.require' => 'referrer_id is null',
        'referrer_id.number'  => 'referrer_id must be numbers',
        'referrer_source.require' => 'referrer_source is null',
        'referrer_source.number' => 'referrer_source must be numbers',
        'code.require' => 'code is null',
        'code.number'  => 'code is null',
    ];
    protected $scene = [
        'register' => 'user_phone,referrer_id,referrer_source',
        'cPost'    => 'user_phone,referrer_id,referrer_source,code'
    ];

}