<?php

namespace app\api\controller;

use think\Controller;
use think\Request;
use app\api\extend\Basic;
use app\api\untils\MessageUntils;
use app\model\Users;
use app\model\NoteLog;
use think\Session;
use think\Cookie;

class Member extends Basic
{
    public function login(Request $request) {

        $post = $request->param();
        $user = new Users();

        $user_data = $user->get(['user_phone' => $post['phone']]);
        
        $data['data'] = '';
        if (empty($user_data->id)) {            
            $result = $user->validate(true)->save([
                'user_phone'  => $post['phone'],
                'referrer_id' => $post['referrer_id'],
            ]);
            
            if (false === $result) {
                $data['status'] = 101;
                $data['msg']    = $user->getError();
            }
        } else {        
                $data['msg'] = '已注册';
                $data['status'] = 200;
        }
        
        return $this->response($data['msg'], $data['status'],$data['data']);
    }
    
    /**
     * 发送短信
     * @param Request $request
     * @return type
     */
    public function sendSms(Request $request) {
        $phone   = $request->param('phone');
        $noteLog = new NoteLog();
        $num     = $noteLog->where('phone', $phone)->where('is_success',1)->count();   
        
        $data['data'] = '';
        $data['status'] = 101;
        if (check_phone($phone)) {
            if ($num > 7) {
                $data['msg'] = '短信发送超过上限';
            } else {
                $result['statusMsg']  = '';
                $result['statusCode'] = '';
                
                $message = new MessageUntils();
                $_code   = mt_rand(1000, 9999) . '';
                $result  = $message->sendCCPSMS($phone, array($_code, '5分钟'), 214759);

                $noteLog->phone        = $phone;
                $noteLog->template_msg = '【同联商业】您的验证码为'.$_code.'，请于5分钟内正确输入，如非本人操作，请忽略此短信。';
                $noteLog->code         = $_code;
                $noteLog->is_success   = $result['statusCode'] == 0 ? 1 : 2;
                $noteLog->send_time    = date('Y-m-d H:i:s');
                $noteLog->save();

                Session::set('_code', $_code);
               
                $data['data']   = $_code;
                $data['msg']    = ($result['statusCode'] == 0) ? '获取短信成功':$result['statusMsg'];
                $data['status'] = ($result['statusCode'] == 0) ? 200 : 101;                
            }
        } else {
            $data['msg']    = '手机号码错误';
        }
        
        return $this->response($data['msg'], $data['status'], $data['data']);
    }

    /**
     * 邀请注册
     * @param Request $request
     * @return type
     */
    public function invite(Request $request){

        $post = $request->param();
        $code = Session::pull('_code');
        $phone = isset($post['phone'])? $post['phone']:'';
        $referrer_id     = $post['referrer_id']? $post['referrer_id']:'';
        $referrer_source = $post['referrer_source']? $post['referrer_source']:'';
        $code = $post['code']? $post['code']:'';
        
        $data['data']   = '';
        $data['status'] = 101;
        $data['msg']    = '';
       
        $result = $this->validate([
            'user_phone' => $phone,
            'referrer_id'     => $referrer_source,
            'referrer_source' => $referrer_source,
            'code'            => $code
                ], 'Users.cPost');

        if(true === $result) {         
            $code = Session::get('_code');
            
            if ($post['code'] == $code) {
                $user      = new Users();
                $user_data = $user->get(['user_phone' => $phone]);

                $data['data'] = '';
                if (empty($user_data->id)) {
                    $result = $user->validate(true)->save([
                        'user_phone'  => $phone,
                        'referrer_id' => $referrer_id,
                        'referrer_source' => $referrer_source,
                    ]);

                    if (false === $result) {
                        $data['msg'] = $user->getError();
                    } else {
                        $data['data']   = ['id'=> $user->id];
                        $data['msg']    = '注册成功';
                        $data['status'] = 200;
                    }
                } else {
                    $data['msg'] = '已注册';
                }
            } else {
                $data['msg'] = '请重新获取验证码';
            }

        } else {
            $data['msg']   = $result;
        }
        
        return $this->response($data['msg'], $data['status'], $data['data']);
    }
}
