<?php

namespace app\model;

use Think\Db;
use think\Model;

class AppVersion extends Model
{
    protected $table = 'u_app_version';

    /**
     * 获取最近版本号
     *
     * @param string $type
     * @return mixed
     */

    public function getVersion($type = 'android')
    {

        $type = $type == 'android' ? 1 : 0;
        $param["type"] = $type;
        $param["is_del"] = 0;
     //   return $this->field("id,version_no,type,create_time,intro,CONCAT('".CK_IMG_URL."' , app_path) as app_path")
       return $this->field("id,version_no,type,create_time,intro, app_path")
            ->where($param)
            ->order("id desc")
            ->limit(1)
            ->select()[0];
    }

    /**
     * 获取版本历史
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function getVersionList()
    {
        $param["is_del"] = 0;
        return $this->field("id,version_no,IF(type = 0,'ios','android') as type ,create_time,intro,app_path")
            ->where($param)
            ->order("id desc")
            ->select();
    }

    /**
     * 添加版本号
     * @param $param
     * @return array
     */
    public function addVersion($param)
    {
        Db::startTrans();
        try {
            $id = $this->save($param);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }
    }

}
