<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2017/12/20
 * Time: 18:01
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\AdminModel;
use app\model\FollowUp;
use app\model\SubletModel;
use think\Db;
use think\Session;


class Transfer extends Basic
{
    /**
     * 转铺列表
     *
     * @return \think\response\View
     */
    public function index() {
        return view('transfer/index');
    }

    /**
     * 获取转铺列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $where = array();

        if (!empty($params['start_date']) && empty($params['end_date'])) {
            $where['create_time'] = ['> time', $params['start_date']];
        }

        if (!empty($params['end_date']) && empty($params['start_date'])) {
            $where['create_time'] = ['< time', $params['end_date']];
        }

        if (!empty($params['start_date']) && !empty($params['end_date'])) {
            $where['create_time'] = ['between time', [$params['start_date'],$params['end_date']]];
        }

        if (!empty($params['name'])) {
            $where['appellation'] = ['like', $params['name'].'%'];
        }

        if (!empty($params['phone'])) {
            $where['tel'] = ['like', $params['phone'].'%'];
        }

        if (!empty($params['shop_name'])) {
            $where['shop_name'] = ['like', $params['shop_name'].'%'];
        }

        $sublet = new SubletModel();

        $fields = 'id,shop_name,manage_type,address_detail,province,city,district,expected_rent,appellation,tel,create_time,status';

        $data['list'] = $sublet->getSublet($pageNo, $pageSize, 'id desc', $fields, $where);

        $data['total'] = $sublet->getSubletTotal($where);
        return $this->response($data['status'], $data['msg'], $data);
    }


    /**
     * 设置转为商铺
     *
     * @return array
     */
    public function putAway() {
        $data['status'] = 200;
        $data['msg']    = '';
        $data['data']   = '';
        $params = $this->request->param();
        $sublet = new SubletModel();
        $sublet_data = $sublet->field('id,house_id')->where('id',$params['id'])->find();

        if ($sublet_data['id']) {

            if ($sublet_data['house_id']) {
                $status = 2;
            } else {
                /***客户自己填写的转铺信息，在B端后台发布商铺更改为2***/
                $status = 1;
            }
            $sublet->update([
                'id'     => $sublet_data['id'],
                'status' => $status
            ]);

            $house = Db::table('houseinfos')->field('id,room_num_left')->where('id', $sublet_data['house_id'])->find();
            if ($house) {
                Db::table('houseinfos')->where('id', $house['id'])->update([
                    'room_num_left' => $house['room_num_left'] + 1
                ]);//自增1
                $data['msg']    =  '剩余铺数+1';
            } else {
                $data['msg'] = '请在同联后台管理中心，根据客户手机号补充信息。';
            }
        } else {
            $data['status']  = 101;
            $data['msg']     = '没有该商铺信息';
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    /**
     * 添加跟进信息
     *
     * @return \think\Response
     */
    public function addFollow() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();

        $follow = new FollowUp();
        $follow->save([
            'content'  => $params['content'],
            'sublet_id' => $params['id'],
            'admin_id' => Session::get('userId'),
            'create_time' => date('Y-m-d H:i:s'),
            'type' => $params['type']
        ]);

        if (!$follow->id) {
            $data['status'] = 101;
            $data['msg']    = '操作失败';
        }

        return $this->response($data['status'],$data['msg'],['id'=> $follow->id]);
    }

    /**
     * 获得跟进信息
     *
     * @return \think\Response
     * @throws \think\exception\DbException
     */
    public function FollowList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();

        if ($params['id']) {
            $follow = new FollowUp();
            $users = new AdminModel();
            $list = $follow->where([
                'sublet_id' => $params['id'],
                'type'      => $params['type']
            ])->select();
            foreach ($list as $k=>$v) {
                $data['data'][$k] = $v;
                $data['data'][$k]['admin_name'] = $users->field('name')->find()['name'];
            }

        } else {
            $data['status'] = 101;
            $data['msg']    = 'id is null';
        }

        return $this->response($data['status'],$data['msg'],$data['data']);
    }

}