<?php

namespace app\model;

use think\Model;
use think\Db;

class Agents extends Model
{
    /**
     * 查询经纪人
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $house_id 查询该街铺和商铺的经纪人评论信息
     * @return type
     */
    public function getUser($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $house_id = '') {
        if ($house_id == '') {
            $data = $this->field($field)->alias('a')
                    ->join('u_evaluate b', 'a.id = b.agents_id', 'left')
                    ->where($params)
                    ->where('level=2 or level=5')
                    ->group('a.id')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        } else {
            $data = $this->field($field)->alias('a')
                    ->join('u_evaluate b','a.id = b.agents_id','left')
                    ->where('find_in_set('.$house_id.', house_ids) or find_in_set('.$house_id.', house_ids2)')
                    ->where($params)
                    ->where('level=2 or level=5')
                    ->group('a.id')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        }

        return $data;
    }
    
    /**
     * 经纪人详情
     * 
     * @param type $id
     * @return boolean
     */
    public function agentsDetail($id) {
        if ($id) {
            $result = $this->field('id,realname,created,sub_shopname,head_portrait')
                    ->where('level=2 or level=5')
                    ->where('id',$id)->find();
            $result['head_portrait'] = 'user_header/'.$result['head_portrait'];   //头像
            $evaluate_grade = Db::table('u_evaluate')
                    ->field('sum(evaluate_grade) as evaluate_grade, count(*) as evaluate_num')
                    ->where('agents_id',$id)->where('is_show',0)->find();

            $result['evaluate_grade'] = $evaluate_grade['evaluate_grade'];   //评分等级
            $result['evaluate_num']   = $evaluate_grade['evaluate_num'];        //评论数量
            $result['watch_shop']     = Db::table('u_appoint_watch_shop')
                    ->where('agents_id',$id)->count(); //看铺

            $result['head_portrait'] = ADMIN_URL_TL.$result['head_portrait'];
            $journal = new JournalAccounts();
            $fields  = 'count(j.id) as num';
            $result['JournalAccounts'] = $journal->getJournalHouseInfoId($fields, $id)['num'];  //成交记录

            $current_time = time();
            $user_time    = strtotime($result['created']);
            $year  = date('Y', $current_time) - date('Y', $user_time);

            //入职年限
            if ($year == 0) {
               $result['created'] = $year .'个月以上';
            } else {
               $result['created'] = $year . '年以上';
            }

            $result['label'] = array(0=>'待定标签数据',1=>'待定标签数据');
            $data = $result;
        } else {
            $data = false;
        }
        
        return $data;
    }

    /**
     * 查询经纪人列表
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @param string $house_id
     * @return false|\PDOStatement|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getAgents($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $house_id = '') {
        if ($house_id == '') {
            $data = $this->field($field)
                ->where($params)
                ->where('level=2 or level=5')
                ->order($order_)
                ->limit($pageSize)
                ->page($pageNo)
                ->select();
        } else {
            $data = $this->field($field)
                ->where('find_in_set('.$house_id.', house_ids) or find_in_set('.$house_id.', house_ids2)')
                ->where($params)
                ->where('level=2 or level=5')
                ->order($order_)
                ->limit($pageSize)
                ->page($pageNo)
                ->select();
        }

        return $data;
    }
}
