<?php

namespace app\model;

use think\Model;
use think\helper\Time;

class JournalAccounts extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'Journalaccounts';
    protected $db;

    function __construct()
    {
        $this->db = Db($this->table);
    }

    /**
     * 获取月均价
     * @return float
     */
    function getTurnover()
    {
        $timeArr = Time::lastWeek();
        $signStartTime = date("Y-m-d H:i:s", $timeArr[0]);
        $signEndTime = date("Y-m-d H:i:s", $timeArr[1]);
        $where_['singntime'] = array( "between", array( $signStartTime, $signEndTime ) );
        return $this->db
            ->where($where_)
            ->count("id");
    }
}
