<?php

namespace app\api\controller;

use think\Request;
use app\api\extend\Basic;
use app\api\untils\MessageUntils;
use app\model\Users;
use app\model\NoteLog;
use think\Session;
use app\api\untils\JwtUntils;
class Member extends Basic
{
    public $user;

    public function __construct(Request $request = null) {
        parent::__construct($request);
        $this->user = new Users();
    }

    public function login() {

        $data['data']   = '';
        $data['status'] = 101;
        
        if ($this->request->has('phone','post') && $this->request->has('pwd','post')) {
            $user_data = $this->user->get([
                'user_phone' => $this->params['phone'],
                'status'     => 0,
            ]);

            if (isset($user_data->id)) {
                if ($user_data->user_pswd == md5(md5($this->params['pwd']) . '+123')) {
                    
                    $jwt_data['id']         = $user_data->id;
                    $jwt_data['user_nick']  = $user_data->user_nick;
                    $jwt_data['user_phone'] = $user_data->user_phone;

                    $jwt = new JwtUntils();              
                    $data['data'] = $user_data->getData();
                    $data['data']['last_login_ip'] = long2ip($data['data']['last_login_ip']);
                    
                    $data['data']['authToken'] = $jwt->createToken($jwt_data);
                    $data['msg']    = '登陆成功';
                    $data['status'] = 200;
                    Session::set('u_user', $data['data']);
                    $user_data->last_login_ip = ip2long($this->request->ip());
                    $user_data->last_login_time = date('Y-m-d H:i:s');
                    $user_data->save();
                } else {
                    $data['msg'] = '密码错误';
                }
            } else {        
                $data['msg']    = '没有该用户';
            }
        } else {
            $data['msg']    = '用户名或密码为空';
        }       
        
        return $this->response($data['status'], $data['msg'],$data['data']);
    }
    
    /**
     * 发送短信
     * @param Request $this->request
     * @return type
     */
    public function sendSms() {
        $data['data']   = '';
        $data['status'] = 101;
        if ($this->request->param('phone')) {
            $phone = $this->request->param('phone');
            $noteLog = new NoteLog();
            $num     = $noteLog->where('phone', $phone)->where('is_success',1)->count();   
            
            if (check_phone($phone)) {
                if ($num > 7) {
                    $data['msg'] = '短信发送超过上限';
                } else {
                    $result['statusMsg']  = '';
                    $result['statusCode'] = '';

                    $message = new MessageUntils();
                    $_code   = mt_rand(1000, 9999) . '';
                    $result  = $message->sendCCPSMS($phone, array($_code, '5分钟'), 214759);

                    $noteLog->phone        = $phone;
                    $noteLog->template_msg = '【同联商业】您的验证码为'.$_code.'，请于5分钟内正确输入，如非本人操作，请忽略此短信。';
                    $noteLog->code         = $_code;
                    $noteLog->is_success   = $result['statusCode'] == 0 ? 1 : 2;
                    $noteLog->send_time    = date('Y-m-d H:i:s');
                    $noteLog->save();

                    Session::set('_code', $_code);

                    $data['data']   = ['code'=> $_code];
                    $data['msg']    = ($result['statusCode'] == 0) ? '发送短信成功':$result['statusMsg'];
                    $data['status'] = ($result['statusCode'] == 0) ? 200 : 101;                
                }
            } else {
                $data['msg'] = '手机号码错误';
            }
        } else {
            $data['msg'] = '手机号码为空';
        }
                
        return $this->response($data['status'], $data['msg'], $data['data']);
    }    
    
    public function register() {      
        $result = 0;

        if ($this->request->has('type','post')) {
            $type = $this->params['type'];
        
            //根据不同的类型验证不同的场景
            switch ($type) {
                case 'add' : $check = 'users.register';             
                    break;
                case 'invite' : $check = 'users.invite';
                    break;
                default:    
                        $check = 'users.edit';
                    break;
            }    
      
            $result = $this->validate([
                'user_phone' => $this->request->param('phone'),
                'user_pswd'  => $this->request->param('pwd'),
                'user_pswd2' => $this->request->param('pwd2'),
                'referrer_id' => $this->request->param('referrer_id'),
                'referrer_source' => $this->request->param('referrer_source'),
                'code' => $this->request->param('code'),
                'user_nick' => $this->request->param('user_nick')
                    ], $check);
        }

        $data['status'] = 101;
        $data['data']   = '';
        if (true === $result){
            $user_data = $this->user->get(['user_phone' => $this->params['phone']]);
            $date = date('Y-m-d H:i:s');
            if (empty($user_data->id)) {
                $insert_data['referrer_id'] = $this->request->param('referrer_id');
                $insert_data['referrer_source'] = $this->request->param('referrer_source');
                $insert_data['status'] = 0;
                $insert_data['create_time'] = $date;
                $insert_data['update_time'] = $date;
                $insert_data['last_login_time'] = $date;
                $insert_data['last_login_ip'] = ip2long($this->request->ip());
                $insert_data['user_phone'] = $this->request->param('phone');
                //不是邀请注册
                if ($type != 'invite') {
                    $insert_data['user_nick']  = $this->request->param('user_nick');
                    $insert_data['user_pswd']  = md5(md5($this->request->param('pwd')) . '+123');
                    $insert_data['user_pic']   = $this->request->param('user_pic');
                    $this->user->save($insert_data);//注册用户
                    $data['data'] = ['id' => $this->user->id];
                    $data['msg']    = '注册成功';
                    $data['status'] = 200;
                }
                
                $code = Session::get('_code');
                if ($this->request->param('code') == $code) {
                    $this->user->save($insert_data);//邀请注册用户
                    Session::delete('_code');
                    $data['data']   = ['id'=> $this->user->id];
                    $data['msg']    = '注册成功';
                    $data['status'] = 200;
                } else {
                    $data['msg'] = '验证码错误';
                }
            } else {                
                $user_data->user_nick  = $this->request->param('user_nick')? $this->request->param('user_nick') : $user_data->user_nick;
                $user_data->user_phone =  $this->request->param('phone') ? $this->request->param('phone') : $user_data->user_phone;
                $user_data->user_pswd  = $this->request->param('pwd') ? $this->request->param('pwd') : $user_data->user_pswd;
                $user_data->user_pic   = $this->request->param('user_pic') ? $this->request->param('user_pic') : $user_data->user_pic;
                $user_data->referrer_id     =  $this->request->param('referrer_id') ? $this->request->param('referrer_id') : $user_data->referrer_id;
                $user_data->referrer_source =  $this->request->param('referrer_source') ? $this->request->param('referrer_source') : $user_data->referrer_source;
                $user_data->status = $this->request->param('status') ? $this->request->param('status') : $user_data->status;
                $user_data->update_time     = $date;
                $user_data->last_login_ip   = $this->request->param('last_login_ip') ? $this->params['last_login_ip'] : $user_data->last_login_ip;

                $user_data->save();
                $data['data'] = ['id' => $user_data->id];
            }
        } else {
            $data['msg']    = $result? $result:'type参数为空' ;
        }
        return $this->response($data['status'], $data['msg'], $data['data']);
    }
}
