<?php

namespace app\api\controller;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/8
 * Time : 11:07
 * Intro:
 */

use app\api\extend\Basic;
use app\model\BannerModel;
use think\Request;

class Banner extends Basic
{
    protected $bannerModel;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->bannerModel = new BannerModel();
    }

    /**
     * 查询banner列表
     * @return \think\Response
     */
    public function getBannerList()
    {
        $field = "id,title,pic_path,url,sort,is_show,create_time,update_time";
        $params['is_show'] = array( "eq", 0 );
        $result = $this->bannerModel
            ->getBannerList(1, 15, "sort desc", $field, $params);
        return $this->response("200", "request success", $result);
    }


    /**
     * 新增or修改数据
     * @return \think\Response
     */
    public function addOrSave()
    {
        $params = array(
            "id" => 2,
            "is_show" => 0
        );
        $msg = isset($params['id']) ? "修改" : "新增";
        $result = $this->bannerModel->addOrUpdate($params);
        if ($result['code'] == 200) {
            return $this->response("200", $msg . "成功", $result["msg"]);
        } else {
            return $this->response("101", $msg . $result["msg"]);
        }
    }

    public function upIsShow()
    {
        $params = array(
            "id" => 1,
            "is_show" => 1
        );
        $result = $this->bannerModel->upIsShow($params);
        if ($result['code'] == 200) {
            return $this->response("200", "update success", $result["msg"]);
        } else {
            return $this->response("101", "update error");
        }
    }


}