<?php

namespace app\api\controller;

use app\api\extend\Basic;
use app\model\AppointWatchShop;
use app\model\HouseInfos;
use think\helper\Time;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/8
 * Time : 17:18
 * Intro: 预约看铺模块
 */
class AppointmentTime extends Basic
{

    protected $db;
    protected $appointmentTimeModel;
    protected $houseInfoModel;

    function __construct($request = null)
    {
        parent::__construct($request);
        $this->appointmentTimeModel = new AppointWatchShop();
        $this->houseInfoModel = new HouseInfos();
    }

    /**
     * 增加预约楼盘信息
     * @return \think\Response
     */
    public function addAppointmentSeeShop()
    {
        $params = $this->params;
     /*   $params = array(
            "user_id" => 1,
            "house_id" => 1,
            "house_title" => "楼盘1",
            "appellation" => "张三",
            "phone" => "13817616312",
            "expect_time" => time(),
            "other_require" => "没有其他要求"
        );*/
        //todo 验证楼盘信息
        if (isset($params["house_id"]) && isset($params["house_title"])) {
            $where_["house_id"] = $params["house_id"];
            $where_["title"] = $params["title"];
            $houseInfo = $this->houseInfoModel->getHouseDetail("id", $where_);
            if (count($houseInfo) <= 0) {
                return $this->response("101", "楼盘ID或楼盘名错误");
            }
        } else {
            return $this->response("101", "楼盘信息不能为空");
        }
        //todo 参数校验
        if (!isset($params["phone"]) || !preg_match('/1[345678]\d{9}/', $params["phone"])) {
            return $this->response("101", "手机号为空或手机号无效");
        }

        if (!isset($params["expect_time"]) || $params['expect_time'] <= Time::today()) {
            return $this->response("101", "预约时间为空，或者小于当前时间");
        }
        $result = $this->appointmentTimeModel->insertAppointWatchShop($params);
        if ($result["code"] == 200) {
            return $this->response("200", "数据保存成功", $result["msg"]);
        }

        return $this->response("101", "数据保存失败");

    }

    public function getAppointmentSeeShopList(){

    }


}