<?php

namespace app\model;

use think\Model;
use think\Db;

class AttentionModel extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_attention';
    protected $db;

    public function __construct()
    {
        $this->db = Db($this->table);
    }

    /**
     * 新增或取消我关注的店铺
     * @param $params
     * @return array
     */
    public function addOrUpdateAttentionShop($params)
    {
        $arr = array();

        if (isset($params['user_id'])) {
            $arr["user_id"] = $params['user_id'];
        }
        if (isset($params['house_id'])) {
            $arr["house_id"] = $params['house_id'];
        }


        $saveWhere = array();
        if (isset($params['id'])) { //取消关注
            $result = $this
                ->where("id=" . $params['id'])
                ->select();
            if (count($result) > 0) {
                $saveWhere["id"] = $params["id"];
                $arr["is_del"] = 1;
            } else {
                return [ "code" => "101", "msg" => "数据不存在" ];
            }
        } else {//关注
            //保存的时候可能是上次取消关注过的所以改遍状态就行了
            $where_["user_id"] = $params['user_id'];
            $where_["house_id"] = $params['house_id'];
            $res = $this
                ->where($where_)
                ->select();

            if (count($res) > 0) {
                $saveWhere["id"] = $res[0]["id"];
                $arr["is_del"] = 0;
                $id = $res[0]["id"];
            } else {
                $arr["create_time"] = date("Y-m-d H:i:s", time());
                $arr["update_time"] = date("Y-m-d H:i:s", time());
            }
        }
        Db::startTrans();
        try {
            if (isset($saveWhere["id"])) {
                $this->save($arr, $saveWhere);
            } else {
                $this->save($arr);
                $id = $this->id;
            }
            $id = isset($id) ? $id : $params["id"];
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }
    }

    /**
     * 获取我关注的商品列表
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $param
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function myAttentionList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $param)
    {
        $params["a.user_id"] = $param["user_id"];
        $params["a.is_del"] = $param["is_del"];
        //$params["b.room_num_left"] = array( "<>", 0 ); //剩余数为0 的商品不显示
        $params["b.show_all"] = array( "eq", 0 ); //只显示公开的楼盘
        return $this->field($field)
            ->alias("a")
            ->join('houseinfos b', 'a.house_id = b.id', 'LEFT')
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

    /**
     *根据userId和楼盘id获取是否关注此商铺
     * @param $params
     * @return mixed
     */
    public function getAttentionByUserIdAndHouseId($params)
    {
        $result = $this->field("id")
            ->where($params)
            ->limit(1)
            ->select();
        if (count($result) > 0) {
            return $result[0];
        }
        return null;
    }
}
